/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.wizards.project;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import jp.sf.maskat.runtime.PropertyInitializer;
import jp.sf.maskat.ui.MaskatUIPlugin;
import jp.sf.maskat.ui.Messages;
import jp.sf.maskat.ui.wizards.project.PluginResourceData;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.ProjectContentsLocationArea;
import org.eclipse.ui.internal.ide.filesystem.FileSystemSupportRegistry;

public class NewMaskatProjectCreationPage
extends WizardPage {
    public static final String PAGE_ID = "jp.sf.maskat.ui.newMaskatProjectCreationPage";
    private String initialProjectFieldValue;
    protected CheckboxTableViewer viewer;
    protected Text projectNameField;
    protected Label projectLabel;
    private Listener nameModifyListener = new Listener(){

        public void handleEvent(Event e) {
            NewMaskatProjectCreationPage.this.setLocationForSelection();
            boolean valid = NewMaskatProjectCreationPage.this.validatePage();
            NewMaskatProjectCreationPage.this.setPageComplete(valid);
        }
    };
    protected ProjectContentsLocationArea locationArea;
    protected static final int SIZING_TEXT_FIELD_WIDTH = 250;
    protected Text maskatFWPath;
    protected Button shouldCopy;
    protected IPath frameworkPath;
    protected boolean shouldCopyFlag;

    public NewMaskatProjectCreationPage(IPath path, boolean copy) {
        this(PAGE_ID, path, copy);
        this.setTitle(Messages.getString("wizard.project.title"));
        this.setDescription(Messages.getString("wizard.project.description"));
    }

    public NewMaskatProjectCreationPage(String pageName, IPath path, boolean copy) {
        super(pageName);
        this.frameworkPath = path;
        this.shouldCopyFlag = copy;
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        this.initializeDialogUnits((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.ui.ide.new_project_wizard_page_context");
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createProjectNameGroup(composite);
        Group projectGroup = new Group(composite, 0);
        projectGroup.setLayout((Layout)new GridLayout());
        projectGroup.setLayoutData((Object)new GridData(1808));
        projectGroup.setText(Messages.getString("wizard.project.group.project"));
        this.locationArea = this.createProjectLocationArea(this.getErrorReporter(), (Composite)projectGroup);
        if (this.initialProjectFieldValue != null) {
            this.locationArea.updateProjectName(this.initialProjectFieldValue);
        }
        Group fwGroup = new Group(composite, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginLeft = 5;
        fwGroup.setLayout((Layout)layout);
        fwGroup.setLayoutData((Object)new GridData(1808));
        fwGroup.setText(Messages.getString("wizard.project.group.framework"));
        Label dirLabel = new Label((Composite)fwGroup, 0);
        dirLabel.setText(Messages.getString("wizard.project.label.path"));
        this.maskatFWPath = new Text((Composite)fwGroup, 2048);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.maskatFWPath.setLayoutData((Object)gridData);
        this.maskatFWPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewMaskatProjectCreationPage.this.setPageComplete(NewMaskatProjectCreationPage.this.validatePage());
            }
        });
        this.shouldCopy = new Button((Composite)fwGroup, 131104);
        GridData copyData = new GridData();
        copyData.horizontalSpan = 5;
        this.shouldCopy.setLayoutData((Object)copyData);
        this.shouldCopy.setText(Messages.getString("wizard.project.label.shuldCopy"));
        this.viewer = CheckboxTableViewer.newCheckList((Composite)fwGroup, (int)67584);
        this.shouldCopy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewMaskatProjectCreationPage.this.viewer.getControl().setEnabled(NewMaskatProjectCreationPage.this.shouldCopy.getSelection());
            }
        });
        Table table = this.viewer.getTable();
        GridData pluginGridData = new GridData(1808);
        pluginGridData.horizontalSpan = 3;
        table.setLayoutData((Object)pluginGridData);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn idColumn = new TableColumn(table, 0x1000000);
        idColumn.setText(Messages.getString("wizard.project.plugin.pluginId"));
        idColumn.setWidth(120);
        TableColumn versionColumn = new TableColumn(table, 16384);
        versionColumn.setText(Messages.getString("wizard.project.plugin.version"));
        versionColumn.setWidth(80);
        TableColumn discColumn = new TableColumn(table, 16384);
        discColumn.setText(Messages.getString("wizard.project.plugin.description"));
        discColumn.setWidth(300);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new PluginResouceLabelProvider());
        this.viewer.setInput(this.createTableObjects());
        this.viewer.setAllChecked(true);
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                PluginResourceData data = (PluginResourceData)event.getElement();
                if (data.isRequired()) {
                    CheckboxTableViewer viewer = (CheckboxTableViewer)event.getSource();
                    viewer.setChecked((Object)data, true);
                }
            }
        });
        this.setButtonLayoutData(this.locationArea.getBrowseButton());
        this.initPage();
        this.setPageComplete(this.validatePage());
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    protected ProjectContentsLocationArea createProjectLocationArea(ProjectContentsLocationArea.IErrorMessageReporter reporter, Composite composite) {
        return new ProjectContentsLocationArea(reporter, composite);
    }

    private void initPage() {
        this.maskatFWPath.setText(this.frameworkPath.toString());
        this.shouldCopy.setSelection(this.shouldCopyFlag);
    }

    private Object createTableObjects() {
        ArrayList<PluginResourceData> list = new ArrayList<PluginResourceData>();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("jp.sf.maskat.runtime", "resources");
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement element = elements[j];
                String path = element.getAttribute("path");
                PropertyInitializer initializer = null;
                if (element.getAttribute("propertyInitializer") != null) {
                    try {
                        initializer = (PropertyInitializer)element.createExecutableExtension("propertyInitializer");
                    }
                    catch (CoreException e) {
                        MaskatUIPlugin.log((IStatus)new Status(4, "jp.sf.maskat.ui", 0, e.toString(), (Throwable)e));
                    }
                }
                PluginResourceData data = new PluginResourceData(element.getAttribute("pluginId"), element.getAttribute("version"), path, element.getAttribute("description"), new Boolean(element.getAttribute("required")), extensions[i].getNamespaceIdentifier(), initializer);
                try {
                    if (path != null) {
                        IContributor contributor = element.getContributor();
                        data.setUrl(FileLocator.toFileURL((URL)Platform.getBundle((String)contributor.getName()).getEntry(path)));
                    }
                    list.add(data);
                }
                catch (IOException e) {
                    MaskatUIPlugin.log((IStatus)new Status(4, "jp.sf.maskat.ui", 0, e.toString(), (Throwable)e));
                }
                ++j;
            }
            ++i;
        }
        Comparator comparator = new Comparator(){

            public int compare(Object obj1, Object obj2) {
                int b1 = ((PluginResourceData)obj1).isRequired() ? 1 : 0;
                int b2 = ((PluginResourceData)obj2).isRequired() ? 1 : 0;
                return b2 - b1;
            }
        };
        Collections.sort(list, comparator);
        return list.toArray(new PluginResourceData[0]);
    }

    private ProjectContentsLocationArea.IErrorMessageReporter getErrorReporter() {
        return new ProjectContentsLocationArea.IErrorMessageReporter(){

            public void reportError(String errorMessage) {
                boolean valid;
                NewMaskatProjectCreationPage.this.setErrorMessage(errorMessage);
                boolean bl = valid = errorMessage == null;
                if (valid) {
                    valid = NewMaskatProjectCreationPage.this.validatePage();
                }
                NewMaskatProjectCreationPage.this.setPageComplete(valid);
            }

            public void reportError(String errorMessage, boolean infoOnly) {
                this.reportError(errorMessage);
            }
        };
    }

    private final void createProjectNameGroup(Composite parent) {
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        this.projectLabel = new Label(projectGroup, 0);
        this.projectLabel.setText(IDEWorkbenchMessages.WizardNewProjectCreationPage_nameLabel);
        this.projectLabel.setFont(parent.getFont());
        this.projectNameField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.projectNameField.setLayoutData((Object)data);
        this.projectNameField.setFont(parent.getFont());
        if (this.initialProjectFieldValue != null) {
            this.projectNameField.setText(this.initialProjectFieldValue);
        }
        this.projectNameField.addListener(24, this.nameModifyListener);
    }

    public IPath getLocationPath() {
        return new Path(this.locationArea.getProjectLocation());
    }

    public URI getLocationURI() {
        return this.locationArea.getProjectLocationURI();
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
    }

    public String getProjectName() {
        if (this.projectNameField == null) {
            return this.initialProjectFieldValue;
        }
        return this.getProjectNameFieldValue();
    }

    private String getProjectNameFieldValue() {
        if (this.projectNameField == null) {
            return "";
        }
        return this.projectNameField.getText().trim();
    }

    public void setInitialProjectName(String name) {
        if (name == null) {
            this.initialProjectFieldValue = null;
        } else {
            this.initialProjectFieldValue = name.trim();
            if (this.locationArea != null) {
                this.locationArea.updateProjectName(name.trim());
            }
        }
    }

    void setLocationForSelection() {
        this.locationArea.updateProjectName(this.getProjectNameFieldValue());
    }

    protected boolean validatePage() {
        URI fwUrl;
        IStatus fwLocationStatus;
        IStatus locationStatus;
        IWorkspace workspace = IDEWorkbenchPlugin.getPluginWorkspace();
        String projectFieldContents = this.getProjectNameFieldValue();
        if (projectFieldContents.equals("")) {
            this.setErrorMessage(null);
            this.setMessage(IDEWorkbenchMessages.WizardNewProjectCreationPage_projectNameEmpty);
            return false;
        }
        IStatus nameStatus = workspace.validateName(projectFieldContents, 4);
        if (!nameStatus.isOK()) {
            this.setErrorMessage(nameStatus.getMessage());
            return false;
        }
        IProject handle = this.getProjectHandle();
        if (handle.exists()) {
            this.setErrorMessage(IDEWorkbenchMessages.WizardNewProjectCreationPage_projectExistsMessage);
            return false;
        }
        if (!this.locationArea.isDefault() && !(locationStatus = workspace.validateProjectLocationURI(handle, this.locationArea.getProjectLocationURI())).isOK()) {
            this.setErrorMessage(locationStatus.getMessage());
            return false;
        }
        String path = this.maskatFWPath.getText();
        if (path == null || path.length() == 0) {
            this.setErrorMessage(Messages.getString("wizard.project.msg.error.notfwpath"));
            this.maskatFWPath.setFocus();
            return false;
        }
        if (path.indexOf("/") == -1) {
            path = "/" + path;
        }
        if (!(fwLocationStatus = workspace.validateProjectLocationURI(handle, fwUrl = FileSystemSupportRegistry.getInstance().getDefaultConfiguration().getContributor().getURI(path))).isOK()) {
            this.setErrorMessage(fwLocationStatus.getMessage());
            this.maskatFWPath.setFocus();
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.projectNameField.setFocus();
        }
    }

    public boolean useDefaults() {
        return this.locationArea.isDefault();
    }

    public boolean shouldCopyMaskatFramework() {
        return this.shouldCopy.getSelection();
    }

    public IPath getMaskatFrameworkPath() {
        return new Path(this.maskatFWPath.getText());
    }

    public PluginResourceData[] getSelectedPlugins() {
        Object[] select = this.viewer.getCheckedElements();
        PluginResourceData[] result = new PluginResourceData[select.length];
        int i = 0;
        while (i < select.length) {
            result[i] = (PluginResourceData)select[i];
            ++i;
        }
        return result;
    }

    private class PluginResouceLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private Image pluginImage = MaskatUIPlugin.getImage("IMG_WIZBAN_PLUGIN");
        private Image requiredPluginImage = MaskatUIPlugin.getImage("IMG_WIZBAN_REQUIRED_PLUGIN");

        private PluginResouceLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return ((PluginResourceData)element).isRequired() ? this.requiredPluginImage : this.pluginImage;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            PluginResourceData data = (PluginResourceData)element;
            switch (columnIndex) {
                case 0: {
                    return data.getPluginId();
                }
                case 1: {
                    return data.getVersion();
                }
                case 2: {
                    return data.getDescription();
                }
            }
            return null;
        }
    }
}

