/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.core;

/**
 * マスカットの階層構造を走査して処理を行うインターフェースです。
 * <p>
 * Visitor パターンを利用することにより、マスカットの要素（レイアウト、
 * イベント）を変更することなく新しい処理を実行させることができます。
 * </p>
 */
public interface MaskatElementVisitor {

	/**
	 * 指定された要素を訪問します。
	 * 
	 * @param def 訪問する要素
	 */
	void visit(Object def);

}
