/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.core.event;

/**
 * イベント定義のマッピングの定義を行うクラスです
 * このクラスはSource, Target要素の子要素として登録されます。
 *
 */
public class Bind extends AbstractEventElement {

	/**
	 * 属性キー
	 * sourceの子要素として定義された場合の必須属性となる
	 */
	private String fromkey;

	/**
	 * 属性キー
	 * targetの子要素として定義された場合の必須属性となる
	 */
	private String tokey;

	/**
	 * ノード名
	 */
	private String node;

	/**
	 * 親要素がsource要素である場合の属性キーを取得します
	 * 
	 * @return 属性キー
	 */
	public String getFromkey() {
		return fromkey;
	}

	/**
	 * 親要素がsource要素である場合の属性キーを設定します
	 * 
	 * @param fromKey 属性キー
	 */
	public void setFromkey(String fromKey) {
		this.fromkey = fromKey;
	}

	/**
	 * ノード名を取得します
	 * 
	 * @return ノード名
	 */
	public String getNode() {
		return node;
	}

	/**
	 * 親要素がtarget要素である場合の属性キーを設定します
	 * 
	 * @param node 属性キー
	 */
	public void setNode(String node) {
		this.node = node;
	}

	/**
	 * 親要素がtarget要素である場合の属性キーを取得します
	 * 
	 * @return 属性キー
	 */
	public String getTokey() {
		return tokey;
	}

	/**
	 * 親要素がtarget要素である場合の属性キーを設定します
	 * 
	 * @param toKey 属性キー
	 */
	public void setTokey(String toKey) {
		this.tokey = toKey;
	}
}

