/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.core.layout;

import jp.sf.maskat.core.event.Event;
import jp.sf.maskat.core.event.EventDef;

/**
 * Layoutのモデルクラスです
 * 
 * レイアウト定義XMLのlayoutタグに該当するモデルクラスです
 */
public class Layout extends AbstractContainer {

	/**
	 * 親となるLayoutDefクラス
	 */
	private LayoutDef layoutDef;

	/**
	 * 親となるLayoutDefクラスを取得します
	 * 
	 * @return 親となるLayoutDefクラス
	 */
	public LayoutDef getLayoutDef() {
		return layoutDef;
	}

	/**
	 * 親となるLayoutDefクラスを設定します
	 * 
	 * @param layoutDef 親となるLayoutDefクラス
	 */
	public void setLayoutDef(LayoutDef layoutDef) {
		this.layoutDef = layoutDef;
	}

	/**
	 * この部品が属するレイアウトを取得します
	 * 
	 * @return この部品が属するレイアウト
	 */
	public Layout getLayout() {
		return this;
	}

	/**
     * {@inheritDoc}
     */
	public String[] getEventTypes() {
		return new String[] { "onload", "onunload", "onshow", "onhide" };
	}

	/**
     * {@inheritDoc}
     */
	public Event getEvent(String eventType) {
		if (hasEvent(eventType)) {
			EventDef eventDef = getLayout().getLayoutDef().getEventDef();
			Event event = eventDef.findEvent(eventType);
			if (event == null) {
				event = new Event(eventType);
				eventDef.addChild(event);
			}
			return event;
		}
		return null;
	}
}

