/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.core.layout;

/**
 * 未知のコンポーネントに関する例外クラスです
 * 
 */
public class UnknownComponentException extends Exception {

	/**
	 * シリアルバージョンUID
	 */
	private static final long serialVersionUID = -1699133230356696955L;

	/**
	 * デフォルトコンストラクタです
	 * 詳細メッセージに null を使用して、新規例外を構築します。
	 */
	public UnknownComponentException() {
		super();
	}

	/**
	 * コンストラクタです
	 * 指定された詳細メッセージおよび原因を使用して新規例外を構築します。
	 * 
	 * @param message 詳細メッセージ
	 * @param cause 原因
	 */
	public UnknownComponentException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * コンストラクタです
	 * 指定された詳細メッセージを使用して、新規例外を構築します。
	 * 
	 * @param message 詳細メッセージ
	 */
	public UnknownComponentException(String message) {
		super(message);
	}

	/**
	 * コンストラクタです
	 * 指定された原因を使用して新規例外を構築します。
	 * 
	 * @param cause 原因
	 */
	public UnknownComponentException(Throwable cause) {
		super(cause);
	}

}
