/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.editors.layout.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.core.layout.LayoutElement;
import jp.sf.maskat.ui.MaskatUIPlugin;
import jp.sf.maskat.ui.Messages;
import jp.sf.maskat.ui.editors.layout.editparts.ComponentEditPart;
import jp.sf.maskat.ui.editors.layout.editparts.LayoutElementEditPart;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.internal.GEFMessages;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

/**
 * コピーアクションクラスです
 * 
 * レイアウトエディタのメニュー、コンテキストメニューから呼び出され 現在選択しているLayoutElementクラスのコピーを行います。
 */
public class CopyComponentAction extends SelectionAction {

	/**
	 * コンストラクタです
	 * 
	 * @param part
	 *            アクションを行うWorkbenchPart
	 */
	public CopyComponentAction(IWorkbenchPart part) {
		super(part);
		setId(ActionFactory.COPY.getId());
		setText(GEFMessages.CopyAction_Label);
		setToolTipText(GEFMessages.CopyAction_Tooltip);
		ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
		setImageDescriptor(sharedImages.getImageDescriptor(ISharedImages.IMG_TOOL_COPY));
		setDisabledImageDescriptor(sharedImages
				.getImageDescriptor(ISharedImages.IMG_TOOL_COPY_DISABLED));
	}

	/**
	 * コピーが行えるか判定します。
	 * 
	 * @return コピーが行える場合、trueを返却します
	 */
	protected boolean calculateEnabled() {
		List objects = getSelectedObjects();
		if (objects.isEmpty()) {
			return false;
		}

		for (int i = 0; i < objects.size(); i++) {
			EditPart part = (EditPart) objects.get(i);
			if (!(part instanceof ComponentEditPart)) {
				return false;
			}
			if (!((LayoutElementEditPart) part).canCopy()) {
				return false;
			}
		}

		// 2010/08/30 BEGIN 改修：親子関係のコンポーネントをコピーできない不具合
		// EditPart parent = ((EditPart) objects.get(0)).getParent();
		// for (int i = 1; i < objects.size(); i++) {
		// EditPart parent2 = ((EditPart) objects.get(i)).getParent();
		// /*
		// * 選択されたコンポーネントの親がそれぞれ異なる場合は実行を行わない
		// */
		// if (parent2 != parent) {
		// return false;
		// }
		// /*
		// * 選択されたコンポーネントが親子関係を持つ場合は実行を行わない
		// *
		// * [component] -> select
		// * |__ [component] -> select
		// */
		// if (objects.contains(parent2)) {
		// return false;
		// }
		// }
		// 選択したコンポーネントを上階層から降順(0,1,2,…)にソートする。
		return true;
//		List partList = new ArrayList();
//		for (int i = 0; i < objects.size(); i++) {
//			_EditPart part = new _EditPart((EditPart) objects.get(i));
//			partList.add(part);
//		}
//
//		// ソート 
//		Collections.sort(partList, new Comparator() {
//			public int compare(Object o1, Object o2) {
//				return ((_EditPart) o1).getIndex() - ((_EditPart) o2).getIndex();
//			}
//		});
//
//		// 選択されたコンポーネントから、
//		// 最も上の階層に存在するコンポーネントと階層情報を取り出す。
//		EditPart parent = ((_EditPart) partList.get(0)).getPart();
//		int parentCount = 1;
//		int pindex = ((_EditPart) partList.get(0)).getIndex();
//		
//		// 最も上の階層配下に含まれないコンポーネントが存在した場合、
//		// falseを返して、処理を終了する。
//		for (int i = 1; i < partList.size(); i++) {
//			EditPart part = ((_EditPart) partList.get(i)).getPart().getParent();
//			int index = ((_EditPart) partList.get(i)).getIndex() - 1;
//
//			// 選択されたコンポーネントが最上階層のコンポーネントと同じ親を持つ場合、
//			// 最上階層となるコンポーネントの数を増やして次のループへ移る。
//			if (parent.getParent() == part) {
//				parentCount++;
//				continue;
//			}
//
//			// 選択されてコンポーネントが最上階層配下に存在しない場合、
//			// falseを返して、処理を終了する。
//			boolean checkFlg = false;
//			while ((pindex < index) || (part != null)) {
//				// 選択されたコンポーネントが親子関係を持つ場合、ループ処理を抜ける。
//				for (int j = 0; j < parentCount; j++ ) {
//					if (((_EditPart) partList.get(j)).getPart() == part) {
//						checkFlg = true;
//						break;
//					}
//				}
//
//				// 階層を一つ上がる。
//				index--;
//				part = part.getParent();
//			}
//
//			if (!checkFlg) {
//				return false;
//			}
//		}
//		// 2010/08/30 END 改修：親子関係のコンポーネントをコピーできない不具合
//
//		return true;
	}

	// 2010/08/30 BEGIN 改修：親子関係のコンポーネントをコピーできない不具合
	/**
	 * コンポーネントのソート用クラス
	 */
//	private class _EditPart {
//		// 階層番号
//		private int index = 0;
//
//		// コンポーネントオブジェクト
//		private EditPart part = null;
//
//		/**
//		 * コンストラクタ
//		 * 
//		 * @param part
//		 *            EditPart
//		 */
//		public _EditPart(EditPart part) {
//			this.part = part;
//			_setIndex(this.part);
//		}
//		
//		/** 
//		 * EditPartを設定する。
//		 * @param _part EditPart
//		 */
//		private void _setIndex(EditPart _part) {
//			EditPart parent = _part.getParent();
//			if (parent != null) {
//				index++;
//				_setIndex(parent);
//			}
//		}
//
//		/**
//		 * EditPartを返す。
//		 * @return EditPart
//		 */
//		public EditPart getPart() {
//			return part;
//		}
//
//		/**
//		 * indexを返す。
//		 * @return int
//		 */
//		public int getIndex() {
//			return index;
//		}
//	}
	// 2010/08/30 END 改修：親子関係のコンポーネントをコピーできない不具合
	
	/**
	 * 選択されたコンポーネントをディープコピーしクリップボードに 格納します。
	 */
	public void run() {
		List editparts = getSelectedObjects();

		List copyTarget = new ArrayList();
		for (int i = 0; i < editparts.size(); i++) {
			EditPart agep = (EditPart) editparts.get(i);
			Object model = agep.getModel();
			copyTarget.add(model);
		}
		List result = new ArrayList();
		for (int i = 0; i < copyTarget.size(); i++) {
			Object model = copyTarget.get(i);
			if (result.contains(model)) {
				continue;
			}
			LayoutElement def = (LayoutElement) model;
			if (isAnscestorContained(copyTarget, def)) {
				continue;
			} else {
				try {
					result.add(def.clone());
				} catch (CloneNotSupportedException e) {
					MessageDialog.openError(this.getWorkbenchPart().getSite().getShell(),
							Messages.getString("layout.cmd.msg.error.title"), //$NON-NLS-1$
							Messages.getString("layout.cmd.copy.msg.error")); //$NON-NLS-1$
					MaskatUIPlugin.log(new Status(IStatus.ERROR,
							MaskatUIPlugin.PLUGIN_ID, IStatus.ERROR, e.getMessage(), e));
				}
			}
		}
		Clipboard.getDefault().setContents(result);
	}

	/**
	 * コピー対象のコンポーネント間で親子関係が発生していないか判定する
	 * 
	 * @param list
	 *            コピー対象コンポーネントリスト
	 * @param def
	 *            コピーを行いたいモデル
	 * @return コピーが可能である場合には true を返却します
	 */
	private boolean isAnscestorContained(List list, MaskatElement def) {
		if (def == null || list == null) {
			return false;
		}
		MaskatElement parentDef = def.getParent();
		while (parentDef != null) {
			if (list.contains(parentDef)) {
				return true;
			}
			parentDef = parentDef.getParent();
		}
		return false;
	}
}
