/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.editors.layout.figures;

import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.core.layout.DynaComponentClass;

import org.eclipse.draw2d.Button;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.FrameBorder;
import org.eclipse.draw2d.GroupBoxBorder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;


public class DynaComponentFigureFactory implements IFigureFactory {

	private String type;

	public DynaComponentFigureFactory(String type) {
		super();
		this.type = type;
	}

	public IFigure createFigure(Object model) {
		DynaComponent component = (DynaComponent) model;
		DynaComponentClass dynaClass = (DynaComponentClass) component.getDynaClass();

		String name = component.getName();
		if (name == null) {
			name = component.getDynaClass().getName();
		}

		IFigure figure = null;
		if (type != null) {
			if ("label".equals(type)) {
				Label label = new Label();
				label.setText(name);
				figure = label;
			}
			if ("button".equals(type)) {
				Button button = new Button(name);
				figure = button;
			}
			if ("frame".equals(type)) {
				Label label = new Label();
				FrameBorder border = new FrameBorder();
				border.setLabel(name);
				label.setBorder(new CompoundBorder(border, new MarginBorder(4)));
				figure = label;
			}
			if ("groupbox".equals(type)) {
				Label label = new Label();
				GroupBoxBorder border = new GroupBoxBorder();
				border.setLabel(name);
				label.setBorder(border);
				figure = label;
			}
			if ("rectangle".equals(type)) {
				Label label = new Label();
				label.setText(name);
				label.setBorder(new CompoundBorder(new LineBorder(), new MarginBorder(1)));
				figure = label;
			}
			if ("roundedRectangle".equals(type)) {
				RoundedRectangle rounded = new RoundedRectangle();
				rounded.setCornerDimensions(new Dimension(16, 16));
				figure = rounded;
			}
			if ("ellipse".equals(type)) {
				figure = new Ellipse();
			}

			if (figure != null) {
				figure.setForegroundColor(ColorConstants.black);
				figure.setFont(TextFigure.DEFAULT_FONT);
				figure.setOpaque(true);
				figure.setLayoutManager(new XYLayout());
				return figure;
			}
		}

		/* returns default figure */
		if (dynaClass.isContainer()) {
			return new DynaComponentFigure(name, PositionConstants.LEFT);
		}
		return new DynaComponentFigure(name);
	}

}
