/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.views.properties.tabbed.beanwrapper;

import jp.sf.maskat.core.event.Event;
import jp.sf.maskat.ui.Messages;
import jp.sf.maskat.ui.views.properties.tabbed.command.AddTreeNodeCommand;
import jp.sf.maskat.ui.views.properties.tabbed.masterdetails.EventPropertiesMasterDetailsBlock;
import jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper.AbstractTreeNode;
import jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper.HTTPHeaderTreeNode;
import jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper.ITreeNode;
import jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper.LocalDataBindingTreeNode;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.TreeViewer;


public class EventTreeNode extends AbstractTreeNode {

	public EventTreeNode(Event event) {
		super(event);
	}
	
	protected void loadChildren() {
		Event event = (Event) maskatElement;
		
		if (!event.isEnable()) {
			return;
		}
		
		if (event.getType().equals("remote")) {
			HTTPHeaderTreeNode headerTreeNode = new HTTPHeaderTreeNode(event);
			addChild(headerTreeNode);
		}

		LocalCallbackFunctions localCallbackFunctionsTreeNode = new LocalCallbackFunctions(
				event);
		LocalDataBindingTreeNode localDataBindingTreeNode = new LocalDataBindingTreeNode(
				event);

		addChild(localCallbackFunctionsTreeNode);
		addChild(localDataBindingTreeNode);

	}

	public IMenuManager fillContextMenu(final TreeViewer treeViewer, IMenuManager manager) {
		if (!((Event) maskatElement).isEnable()) {
			return super.fillContextMenu(treeViewer, manager);
		}
		final ITreeNode node = this;
		if(!containsChild(HTTPHeaderTreeNode.class)
			&& ((Event) maskatElement).getType().equals("remote")) {
			manager.add(new Action(Messages.getString("eventTreeNode.addHttpHeaders")) { //$NON-NLS-1$
				public void run() {
					ITreeNode childNode = new HTTPHeaderTreeNode((Event)maskatElement); 
					EventPropertiesMasterDetailsBlock.executeCommand(new AddTreeNodeCommand(treeViewer,node,childNode));
				}
			});
		}
		if(!containsChild(LocalCallbackFunctions.class)) {
			manager.add(new Action(Messages.getString("eventTreeNode.addLocalCallbackFunctions")) { //$NON-NLS-1$
				public void run() {
					ITreeNode childNode = new LocalCallbackFunctions((Event)maskatElement); 
					EventPropertiesMasterDetailsBlock.executeCommand(new AddTreeNodeCommand(treeViewer,node,childNode));
				}
			});
		}
		if(!containsChild(LocalDataBindingTreeNode.class)) {
			manager.add(new Action(Messages.getString("eventTreeNode.addLocalDataBindings")) { //$NON-NLS-1$
				public void run() {
					ITreeNode childNode = new LocalDataBindingTreeNode((Event)maskatElement);
					EventPropertiesMasterDetailsBlock.executeCommand(new AddTreeNodeCommand(treeViewer,node,childNode));					
				}
			});
		}
		return super.fillContextMenu(treeViewer, manager);
	}
	
	public boolean isDeletable() {
		return false;
	}
	
	public String getDisplayText() {
		String eventType = "";
		if (!((Event)maskatElement).isEnable())
		{
			eventType = Messages.getString("eventTreeNode.disabledLabel"); //$NON-NLS-1$
		}
		else if (((Event)maskatElement).getType().equals("remote"))
		{
			eventType = Messages.getString("eventTreeNode.remoteLabel"); //$NON-NLS-1$
		}
		else if (((Event)maskatElement).getType().equals("local"))
		{
			eventType = Messages.getString("eventTreeNode.localLabel"); //$NON-NLS-1$
		}
		
		return Messages.getString("eventTreeNode.eventHadlerLabel") + " " + eventType; //$NON-NLS-1$
	}

}
