/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.views.properties.tabbed.beanwrapper;

import jp.sf.maskat.core.event.Bind;
import jp.sf.maskat.ui.Messages;
import jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper.AbstractTreeNode;
import jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper.ITreeNode;


public class TargetBind extends AbstractTreeNode {
	
	private static final String COLUMN_LABEL =
		Messages.getString("TargetBind.columnLabel"); //$NON-NLS-1$
	
	public TargetBind(Bind bind) {
		super(bind);
	}
	
	
	public String getDisplayText() {
		Bind bind = (Bind)maskatElement;
		String nodeName = " - ";
		String cellIndex = " - ";

		if (bind.getNode() != null)
		{
			if  (!(bind.getNode().length() == 0))
			{
				nodeName = bind.getNode();
			}
		}
		if (bind.getTokey() != null)
		{
			if (!(bind.getTokey().length() == 0))
			{
				cellIndex = bind.getTokey();
			}
		}
		return nodeName + " -> " + cellIndex + " " + COLUMN_LABEL;		
	}
	
	/*
	public String getDisplayText() {
		if (((Bind)maskatElement).getNode() == null || ((Bind)maskatElement).getNode().length() == 0) {
			return "<> (Column)";
		}
		return "<" + ((Bind)maskatElement).getNode() + "> (Column)";
	}
	*/
	
	public boolean isCopiable() {
		return true;
	}
	
	public boolean canPasteTo(ITreeNode parent) {
		return (parent != null && parent instanceof TargetChildNode) ? true : false;
	}

}
