/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.views.properties.tabbed.command;

import jp.sf.maskat.ui.MaskatUIPlugin;
import jp.sf.maskat.ui.views.properties.tabbed.masterdetails.EventPropertiesMasterDetailsBlock;
import jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper.ITreeNode;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;


public class DeleteMultiTreeNodesCommand extends Command {
	
	private TreeViewer treeViewer;
	
	private ITreeNode parentNode;
	
	private ITreeNode[] nodesToBeDeleted;
	
	public DeleteMultiTreeNodesCommand(TreeViewer treeViewer, ITreeNode[] nodesToBeDeleted) {
		super();
		this.treeViewer = treeViewer;
		this.parentNode = nodesToBeDeleted[0].getParent();
		this.nodesToBeDeleted = nodesToBeDeleted;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.commands.Command#canUndo()
	 */
	public boolean canUndo() {
		return true;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.commands.Command#execute()
	 */
	public void execute() {
		try {
			for (int i = 0; i < nodesToBeDeleted.length;i ++) {
				parentNode.removeChild(nodesToBeDeleted[i]);
			}
			treeViewer.refresh(parentNode, true);
			treeViewer.setSelection(new StructuredSelection(parentNode));
			
		} catch (Exception e) {
			MaskatUIPlugin.log(new Status(IStatus.ERROR,
					MaskatUIPlugin.PLUGIN_ID, IStatus.ERROR, e.getMessage(), e));
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.commands.Command#undo()
	 */
	public void undo() {
		try {
			ITreeNode newParentTreeNode = EventPropertiesMasterDetailsBlock.getTreeNode(
					parentNode.getModel(), parentNode.getClass());
			parentNode = newParentTreeNode == null ? parentNode : newParentTreeNode;
			for (int i = 0; i < nodesToBeDeleted.length;i ++) {
				parentNode.addChild(nodesToBeDeleted[i]);
			}
			treeViewer.refresh(parentNode, true);
			treeViewer.setSelection(new StructuredSelection(nodesToBeDeleted[0]),true);
			
		} catch (Exception e) {
			MaskatUIPlugin.log(new Status(IStatus.ERROR,
					MaskatUIPlugin.PLUGIN_ID, IStatus.ERROR, e.getMessage(), e));
		}
	}
	
}
