/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.views.properties.tabbed.command;

import jp.sf.maskat.ui.MaskatUIPlugin;
import jp.sf.maskat.ui.views.properties.tabbed.masterdetails.EventPropertiesMasterDetailsBlock;
import jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper.ITreeNode;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;

public class DeleteOneTreeNodeCommand extends Command {
	
	protected TreeViewer treeViewer;
	
	protected ITreeNode parentTreeNode;
	
	protected ITreeNode nodeToBeDeleted;
	
	private ITreeNode selectRootNode = null;
	
	public DeleteOneTreeNodeCommand(TreeViewer treeViewer, ITreeNode parent, ITreeNode nodeToBeDeleted) {
		super();
		this.treeViewer = treeViewer;
		this.parentTreeNode = parent;
		this.nodeToBeDeleted = nodeToBeDeleted;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.commands.Command#canUndo()
	 */
	public boolean canUndo() {
		return true;
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.commands.Command#execute()
	 */
	public void execute() {
		try {
			parentTreeNode.removeChild(nodeToBeDeleted);
			if (selectRootNode == null) {
				selectRootNode = getSelectRootNode();
			} else if (selectRootNode != getSelectRootNode()) {
				selectRootNode = getSelectRootNode();
				treeViewer.refresh();
				treeViewer.expandToLevel(2);
				ITreeNode newtreeNode = EventPropertiesMasterDetailsBlock.getTreeNode(
						parentTreeNode.getModel(), parentTreeNode.getClass());
				treeViewer.setSelection(new StructuredSelection(newtreeNode));
				return;
			}
			treeViewer.refresh(parentTreeNode, true);
			treeViewer.setSelection(new StructuredSelection(parentTreeNode));
			
		} catch (Exception e) {
			MaskatUIPlugin.log(new Status(IStatus.ERROR,
					MaskatUIPlugin.PLUGIN_ID, IStatus.ERROR, e.getMessage(), e));
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.commands.Command#undo()
	 */
	public void undo() {
		try {
			ITreeNode newParentTreeNode = EventPropertiesMasterDetailsBlock.getTreeNode(
					parentTreeNode.getModel(), parentTreeNode.getClass());
			parentTreeNode = newParentTreeNode == null ? parentTreeNode : newParentTreeNode;
			parentTreeNode.addChild(nodeToBeDeleted);
			treeViewer.refresh(parentTreeNode, true);
			treeViewer.setSelection(new StructuredSelection(nodeToBeDeleted),true);
		} catch (Exception e) {
			MaskatUIPlugin.log(new Status(IStatus.ERROR,
					MaskatUIPlugin.PLUGIN_ID, IStatus.ERROR, e.getMessage(), e));
		}
	}

	private ITreeNode getSelectRootNode() {
		TreeSelection selection = (TreeSelection) treeViewer.getSelection();
		TreePath[] paths = selection.getPaths();
		if (paths.length > 0) {
			Object obj = paths[0].getSegment(0);
			if (obj instanceof ITreeNode) {
				return (ITreeNode) obj;
			}
		}
		return null;
	}
}
