/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.wizards.export;

import java.util.ArrayList;
import java.util.regex.Pattern;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IIDEHelpContextIds;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class XMLSchemaSelectionDialog extends SelectionDialog {

    private IAdaptable root;

    private XMLSchemaSelectGroup selectionGroup;
    
    private final static int SIZING_SELECTION_WIDGET_WIDTH = 400;

    private final static int SIZING_SELECTION_WIDGET_HEIGHT = 300;

    public XMLSchemaSelectionDialog(Shell parentShell, IAdaptable rootElement,
            String message) {
        super(parentShell);
        setTitle(IDEWorkbenchMessages.ResourceSelectionDialog_title);
        root = rootElement;
        if (message != null) {
			setMessage(message);
		} else {
			setMessage(IDEWorkbenchMessages.ResourceSelectionDialog_message);
		}
        setShellStyle(getShellStyle() | SWT.RESIZE);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(shell,
			IIDEHelpContextIds.RESOURCE_SELECTION_DIALOG);
    }

    public void create() {
        super.create();
        selectionGroup.setSelectionControl(getOkButton());
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite) super.createDialogArea(parent);
        ArrayList input = new ArrayList();
        input.add(root);

        createMessageArea(composite);
        selectionGroup = new XMLSchemaSelectGroup(composite, input,
            getResourceProvider(IResource.FOLDER | IResource.PROJECT | IResource.ROOT, null),
            WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider(),
            getResourceProvider(IResource.FILE, new ResourceFilter("[\\p{Graph}]*_e.xml$$")), //$NON-NLS-1$
            WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider(), SWT.NONE,
            SIZING_SELECTION_WIDGET_WIDTH, SIZING_SELECTION_WIDGET_HEIGHT);

        return composite;
    }

    private ITreeContentProvider getResourceProvider(final int resourceType,
    		final ResourceFilter filter) {
        return new WorkbenchContentProvider() {
            public Object[] getChildren(Object o) {
                if (o instanceof IContainer) {
                    IResource[] members = null;
                    try {
                        members = ((IContainer) o).members();
                    } catch (CoreException e) {
                        return new Object[0];
                    }
                    ArrayList results = new ArrayList();
                    for (int i = 0; i < members.length; i++) {
                        if ((members[i].getType() & resourceType) > 0) {
                        	if (filter == null || filter.accept(members[i])) { 
                        		results.add(members[i]);
                        	}
                        }
                    }
                    return results.toArray();
                }
                if (o instanceof ArrayList) {
                    return ((ArrayList) o).toArray();
                } 
                return new Object[0];
            }
        };
    }

    private class ResourceFilter {
    	private Pattern namePattern;
    	ResourceFilter(String filterString) {
    		namePattern = Pattern.compile(filterString);
    	}
        public boolean accept(IResource resource) {
        	return namePattern.matcher(resource.getName()).matches();
        }
    }
    
    public IFile getSelectEventXMLFile() { 
    	return (IFile) selectionGroup.getSelectObject();
    }
}
