/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.ui.wizards.project;

import java.net.URL;

import jp.sf.maskat.runtime.PropertyInitializer;

public class PluginResourceData {
	private String pluginId;
	private String version;
	private String path;
	private String description;
	private String uniqueId;
	private PropertyInitializer initializer;
	private boolean required;
	private URL url;
	
	public PluginResourceData(String id, String version, String path,
			String desc, boolean required, String uniqueId, PropertyInitializer initializer) {
		this.pluginId = id;
		this.version = version;
		this.path = path;
		this.description = desc;
		this.required = required;
		this.uniqueId = uniqueId;
		this.initializer = initializer;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public PropertyInitializer getInitializer() {
		return initializer;
	}

	public void setInitializer(PropertyInitializer initializer) {
		this.initializer = initializer;
	}

	public String getPath() {
		return path;
	}

	public void setPath(String path) {
		this.path = path;
	}

	public String getPluginId() {
		return pluginId;
	}

	public void setPluginId(String pluginId) {
		this.pluginId = pluginId;
	}

	public boolean isRequired() {
		return required;
	}

	public void setRequired(boolean required) {
		this.required = required;
	}

	public URL getUrl() {
		return url;
	}

	public void setUrl(URL url) {
		this.url = url;
	}

	public String getVersion() {
		return version;
	}

	public void setVersion(String version) {
		this.version = version;
	}

	public String getUniqueId() {
		return uniqueId;
	}

	public void setUniqueId(String uniqueId) {
		this.uniqueId = uniqueId;
	}

}	
