/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.widget.rialto.commands;

import java.util.ArrayList;
import java.util.List;

import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.core.event.EventDef;
import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.core.layout.LayoutElement;

import org.eclipse.gef.commands.Command;

public class DelRadioCommand extends Command {
	private MaskatElement parent;

	private MaskatElement child;

	private int index;

	private EventDef eventDef;

	private jp.sf.maskat.core.event.Component eventComponent;

	private boolean noAction = false;
	
	private LayoutElement radioGroup;
	
	private LayoutElement radioMember;
	
	private LayoutElement layout;
	

	public DelRadioCommand(MaskatElement parent, MaskatElement child) {
		this.parent = parent;
		this.child = child;
		this.radioGroup = null;
		this.radioMember = null;
		this.layout = null;
		if (child instanceof Component) {
			setRemoveReference(((Component) child).getName());
		}
	}

	public void execute() {

		index = parent.getChildIdx(child);
		parent.removeChild(child);

		if (child instanceof Component) {
			Component component = (Component) child;
			eventDef = component.getLayout().getLayoutDef().getEventDef();
			eventComponent = eventDef.findComponent(component.getName());
			if (eventComponent != null) {
				eventDef.removeChild(eventComponent);
			}
		}
		if (radioGroup != null && radioMember != null) {
			radioGroup.removeChild(radioMember);
			if (radioGroup.getChildren().size() == 0) {
				layout = radioGroup.getLayout();
				layout.removeChild(radioGroup);
			}			
		}
	}

	public void undo() {
		if (noAction) {
			return;
		}
		if (radioGroup != null && radioMember != null) {		
			if (layout != null) {
				layout.addChildToIdx(radioGroup, 0);
			}
			radioGroup.addChild(radioMember);
		}
		parent.addChildToIdx(child, index);
		if (eventDef != null && eventComponent != null) {
			eventDef.addChild(eventComponent);
		}
	}

	public boolean canUndo() {
		return true;
	}

	private void setRemoveReference(String name) {
		List radioGroups = getRadioGroups();
		for (int i = 0; i < radioGroups.size(); i++) {
			DynaComponent group = (DynaComponent) radioGroups.get(i);
			List children = group.getTypedChildren("radioMember");
			for (int j = 0; j < children.size(); j++) {
				DynaComponent member = (DynaComponent) children.get(j);
				if (name.equals(member.get("ref"))) {
					this.radioGroup = group;
					this.radioMember = member;
				}
			}
		}
	}
	
	private List getRadioGroups() {
		ArrayList result = new ArrayList();
		DynaComponent comp = (DynaComponent) this.child;
		List children = comp.getLayout().getChildren();
		for (int i = 0; i < children.size(); i++) {
			Object obj = children.get(i);
			if (obj instanceof DynaComponent) {
				DynaComponent dynaComponent = (DynaComponent) obj;
				if ("radioGroup".equals(dynaComponent.getDynaClass().getName())) {
					result.add(dynaComponent);
				}
			}				
		}	
		return result;
	}
}
