/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.widget.rialto.editpart;

import java.beans.PropertyChangeEvent;
import java.util.List;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;

import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.ui.editors.layout.editparts.ComponentEditPart;

public class RadioGroupEditPart extends ComponentEditPart {
	
	public void setModel(Object model) {
		super.setModel(model);
	}

	protected IFigure createFigure() {
		return new Figure();
	}

	protected List getModelChildren() {
		List result = null;
		if (getModel() instanceof MaskatElement) {
			result = ((MaskatElement) getModel()).getChildren();
		}
		return (result != null) ? result : super.getModelChildren(); 
	}
	
	public void propertyChange(PropertyChangeEvent evt) {
		if ("addChild".equals(evt.getPropertyName()) ||
			"removeChild".equals(evt.getPropertyName())) {
			refresh();
		}
		super.propertyChange(evt);
	}
	
	public boolean canCopy() {
		return false;
	}
	
	public boolean canDelete() {
		return false;
	}
}
