/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.widget.rialto.editpolicy;

import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.core.layout.DynaComponent;
import jp.sf.maskat.ui.editors.layout.commands.AddBasicDefCommand;

import org.apache.commons.beanutils.DynaClass;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;


public class TreeNodeXYLayoutEditPolicy extends XYLayoutEditPolicy {

	protected Command createAddCommand(EditPart child, Object constraint) {
		MaskatElement host = (MaskatElement) getHost().getModel();
		Object childModel = child.getModel();

		DynaClass dynaClass = ((DynaComponent) childModel).getDynaClass();
		if (!"treeNode".equals(dynaClass.getName())) {
			return null;
		}
		if (host.getChildIdx(childModel) != -1) {
			// 本来の親子だったら、コマンドを発行する必要ない
			return null;
		}
		
		MaskatElement childDef = (MaskatElement) childModel;

		// childDefはhostの親ノードの場合、逆に指定することはできない
		MaskatElement parent = host.getParent(); 
		while (parent != null) {
			if (parent == childDef) {
				return null;
			}
			parent = parent.getParent();
		}

		return new AddBasicDefCommand(host, (MaskatElement) childModel);
	}

	protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
		return null;
	}

	protected Command getCreateCommand(CreateRequest request) {
		MaskatElement host = (MaskatElement) getHost().getModel();
		Object newObj = request.getNewObject();

		DynaClass dynaClass = ((DynaComponent) newObj).getDynaClass();
		if (!"treeNode".equals(dynaClass.getName())) {
			return null;
		}
		return new AddBasicDefCommand(host, (MaskatElement) newObj);
	}

	protected Command getDeleteDependantCommand(Request request) {
		return null;
	}

}
