/*
 * Copyright (c) 2006-2010 Maskat Project.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Maskat Project - initial API and implementation
 */
package jp.sf.maskat.widget.rialto.figure;

import java.util.List;

import jp.sf.maskat.core.layout.Component;
import jp.sf.maskat.widget.rialto.editpart.GridEditPart;
import jp.sf.maskat.widget.rialto.editpart.GridHeaderEditPart;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.swt.graphics.Font;


public class GridFigure extends Label {
	public static Font DEFAULT_FONT = new Font(null, "Arial", 8, 0);
	public static int DEFAULT_WIDTH = 80;
	
	private GridEditPart grid;

	public GridFigure(GridEditPart grid) {
		super();
		this.grid = grid;
		setForegroundColor(ColorConstants.black);
		setFont(DEFAULT_FONT);
		setBorder(new LineBorder());
		setLayoutManager(new XYLayout());
	}

	protected void paintFigure(Graphics graphics) {
		super.paintFigure(graphics);
		graphics.translate(bounds.x, bounds.y);
		Component model = (Component) grid.getModel();
		
		if (model.getName() != null) {
			graphics.drawText(model.getName(), 0, 0);
		}

		List headers = grid.getHeadersIt();
		if (headers.size() > 0) {
			int currentX = 0;
			// 垂直線を画く
			for (int i = 0; i < headers.size(); i++) {
				Component header = (Component) ((GridHeaderEditPart) headers.get(i)).getModel();
				
				currentX += GridHeaderEditPart.toHeaderDisplayWidth(header.getWidth());
				graphics.drawLine(currentX, GridHeaderEditPart.headerTop + 1, currentX,
						model.getHeight());
			}
			// 水平線を画く
			int lineHeight = 0;
			try {
				lineHeight = grid.getLineHeight();
			} catch (NumberFormatException e) {
			}
			lineHeight = Math.max(lineHeight, 5);
			int currentY = GridHeaderEditPart.headerHeight + GridHeaderEditPart.headerTop + 1;
			int headerTotalWidth = grid.headerTotalWidth();
			while (currentY <= model.getHeight()) {
				graphics.drawLine(0, currentY, headerTotalWidth, currentY);
				currentY += lineHeight;
			}
		}
		graphics.translate(-bounds.x, -bounds.y);
	}
}
