package jp.sourceforge.masme.entity;

import java.util.Date;

/**
 * 編集情報を表すクラス
 *
 */
public class WorkInfo {

    /**
     * 反映状態
     */
    private ReflectState reflectState = ReflectState.REFLECTED;

    /**
     * 削除フラグ
     * <p>
     * 削除フラグがONで編集中の場合、反映時には本番情報が削除される
     */
    private boolean deleteFlag = false;
    /**
     * 反映予定日
     */
    private Date scheduledDate;

    /**
     * 反映された日時
     */
    private Date reflectedTimestamp;


    public Date getScheduledDate() {
        return scheduledDate;
    }

    public void setScheduledDate(Date scheduleDate) {
        this.scheduledDate = scheduleDate;
    }

    public Date getReflectedTimestamp() {
        return reflectedTimestamp;
    }

    public void setReflectedTimestamp(Date reflectedDate) {
        this.reflectedTimestamp = reflectedDate;
    }

    public ReflectState getReflectState() {
        return reflectState;
    }

    public void setReflectState(ReflectState reflectState) {
        this.reflectState = reflectState;
    }

    public boolean getDeleteFlag() {
        return deleteFlag;
    }

    public void setDeleteFlag(boolean deleteFlag) {
        this.deleteFlag = deleteFlag;
    }

    public String toString() {
        return "workInfo[" + reflectState + "," + deleteFlag
                + ",scheduledDate=" + scheduledDate + "]";
    }

}
