package jp.sourceforge.masme.service;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import jp.sourceforge.masme.entity.WorkEntity;
import jp.sourceforge.masme.target.MaintenanceWorkTarget;

/**
 * メンテナンス対象オブジェクトを取得するためのサービスクラス。
 * <p>
 * 全件取得、IDを指定した取得、修正中の一覧取得などのサービスを提供する。
 */
public interface LoadTargetService {

    MaintenanceWorkTarget get(Class<WorkEntity> targetClass, Serializable id);

    /**
     * 引数で渡されたメンテナンス対象のクラスに対して
     * そのクラスの全てのエンティティを取得します。
     * @param targetClass メンテナンス対象のクラス
     * @return 取得したエンティティのリスト
     */
    List<MaintenanceWorkTarget> loadAll(Class<WorkEntity> targetClass);

    /**
     * 引数で渡されたメンテナンス対象のクラスに対して
     * そのクラスの編集中の全てのエンティティを取得します。
     * @param targetClass メンテナンス対象のクラス
     * @return 取得したエンティティのリスト
     */
    List<MaintenanceWorkTarget> loadEditAll(Class<WorkEntity> targetClass);

    /**
     * 引数で渡されたメンテナンス対象のクラスに対して
     * そのクラスの反映待ちの反映日の一致する全てのエンティティを取得します。
     * もし反映日がnullだった場合には、反映日に依存せずに取得します
     * @param targetClass メンテナンス対象のクラス
     * @param reflectDate 反映日
     * @return 取得したエンティティのリスト
     */
    List<MaintenanceWorkTarget> loadWaitReflectAll(
            Class<WorkEntity> targetClass, Date reflectDate);

}
