package jp.sourceforge.masme.service.impl;

import jp.sourceforge.masme.entity.WorkEntity;
import jp.sourceforge.masme.target.MaintenanceTargetFactory;
import jp.sourceforge.masme.target.MaintenanceWorkTarget;

public class AbstractEntityService<E extends WorkEntity> {
    private Class<E> type;
    protected MaintenanceWorkTarget getMaintenanceWorkTarget(E entity){
        MaintenanceWorkTarget workTarget = maintenanceTargetFactory
                .createMaintenanceTargetEntity(type, entity);
        return workTarget;
    }
    public Class<E> getType(){
        return type;
    }
    public void setType(Class<E> type) {
        this.type = type;
    }
    private MaintenanceTargetFactory maintenanceTargetFactory;

    public void setMaintenanceTargetFactory(
            MaintenanceTargetFactory maintenanceTargetFactory) {
        this.maintenanceTargetFactory = maintenanceTargetFactory;
    }
    /**
     * ジェネリクスを使っても、SpringFrameworkを使った場合にはClass型が取れない。
     * そのためクラス名をインジェクションして対応する方法を提供する。
     * @param typeName
     * @throws ClassNotFoundException
     */
    @SuppressWarnings("unchecked")
    public void setType(String typeName) throws ClassNotFoundException {
        this.type = (Class<E>) Class.forName(typeName);
    }
}
