package jp.sourceforge.masme.service.impl;

import java.io.Serializable;

import jp.sourceforge.masme.entity.WorkEntity;
import jp.sourceforge.masme.service.EditEntityService;
import jp.sourceforge.masme.target.MaintenanceWorkTarget;

public class EditEntityServiceImpl<E extends WorkEntity>
        extends
            AbstractEntityService<E> implements EditEntityService<E> {

    public Serializable add(E entity) {

        MaintenanceWorkTarget workTarget = getMaintenanceWorkTarget(entity);
        workTarget.add();
        return workTarget.getId();
    }

    public void edit(E entity) {
        MaintenanceWorkTarget workTarget = getMaintenanceWorkTarget(entity);
        workTarget.edit();
    }

    public void delete(E entity) {
        MaintenanceWorkTarget workTarget = getMaintenanceWorkTarget(entity);
        workTarget.delete();
    }
    public void cancelEdit(E entity) {
        MaintenanceWorkTarget workTarget = getMaintenanceWorkTarget(entity);
        workTarget.cancelEdit();
    }
}
