package jp.sourceforge.masme.service.impl;

import java.io.Serializable;
import java.util.List;

import jp.sourceforge.masme.entity.WorkEntity;
import jp.sourceforge.masme.service.EditTargetService;
import jp.sourceforge.masme.target.MaintenanceTargetFactory;
import jp.sourceforge.masme.target.MaintenanceWorkTarget;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EditTargetServiceImpl implements EditTargetService {

    /** ログ出力オブジェクト */
    Log log = LogFactory.getLog(EditTargetServiceImpl.class);

    /**
     * @see jp.sourceforge.masme.service.EditTargetService#add(jp.sourceforge.masme.target.MaintenanceWorkTarget,
     *      java.util.List, java.util.List)
     */
    public void add(MaintenanceWorkTarget target, Serializable id,
            List<String> propertyNames, List<Object> propertyValues) {
        target.add(id, propertyNames, propertyValues);

    }

    /**
     * @see jp.sourceforge.masme.service.EditTargetService#cancelEdit(jp.sourceforge.masme.target.MaintenanceWorkTarget)
     */
    public MaintenanceWorkTarget cancelEdit(MaintenanceWorkTarget target) {
        boolean deleted = target.cancelEdit();
        if (deleted) {
            return null;
        } else {
            return target;
        }
    }

    /**
     * @see jp.sourceforge.masme.service.EditTargetService#delete(jp.sourceforge.masme.target.MaintenanceWorkTarget)
     */
    public MaintenanceWorkTarget delete(MaintenanceWorkTarget target) {
        boolean deleted = target.delete();
        if (deleted) {
            return null;
        } else {
            return target;
        }
    }

    /**
     * @see jp.sourceforge.masme.service.EditTargetService#edit(jp.sourceforge.masme.target.MaintenanceWorkTarget,
     *      java.util.List, java.util.List)
     */
    public void edit(MaintenanceWorkTarget target, List<String> propertyNames,
            List<Object> propertyValuesStr) {
        target.edit(propertyNames, propertyValuesStr);
    }

    /**
     * 
     * @see jp.sourceforge.masme.service.EditTargetService#createMaintenanceTarget(java.lang.Class)
     */
    public MaintenanceWorkTarget createMaintenanceTarget(
            Class<? extends WorkEntity> targetClass) {
        MaintenanceWorkTarget entity = (MaintenanceWorkTarget) maintenanceTargetFactory
                .createMaintenanceTargetEntity(targetClass);
        return entity;
    }

    private MaintenanceTargetFactory maintenanceTargetFactory;

    public void setMaintenanceTargetFactory(
            MaintenanceTargetFactory maintenanceTargetFactory) {
        this.maintenanceTargetFactory = maintenanceTargetFactory;
    }
}
