package jp.sourceforge.masme.target;

import java.util.List;

import jp.sourceforge.masme.entity.RealEntity;
import jp.sourceforge.masme.entity.WorkEntity;
import jp.sourceforge.masme.meta.MetaProperty;
import jp.sourceforge.masme.meta.ReferenceMetaProperty;

public interface MaintenanceTargetFactory {
    /**
     * ワーク用のメンテナンス対象を作成します
     * 
     * @param clazz
     * @param entity
     * @return
     */
    MaintenanceWorkTarget createMaintenanceTargetEntity(Class clazz,
            WorkEntity entity);

    /**
     * ワーク用のメンテナンス対象を作成します
     * 
     * @param clazz
     * @param entity
     * @return
     */
    List<MaintenanceWorkTarget> createMaintenanceTargetEntity(Class clazz,
            List<WorkEntity> entities);

    /**
     * 本番用のメンテナンス対象を作成します
     * 
     * @param clazz
     * @param entity
     * @return
     */
    MaintenanceRealTarget createMaintenanceTargetEntity(Class clazz,
            RealEntity entity);

    /**
     * メンテナンス対象を作成します.ワークインスタンスの作成も行います.
     * 
     * @param clazz
     * @return
     */
    MaintenanceTarget createMaintenanceTargetEntity(Class clazz);

    /**
     * {@code ReferenceProperty}のオブジェクトを新たに作成します。
     * @return {@code ReferenceProperty}
     */
    ReferenceProperty createReferenceProperty(MaintenanceTarget target,
            MetaProperty metaProperty);
    /**
     * {@code ValidateProperty}のオブジェクトを新たに作成します。
     * @return {@code ValidateProperty}
     */
    MaintenanceProperty createMaintenanceProperty(MaintenanceTarget target,
            MetaProperty metaProperty);
    /**
     * {@code ValidateProperty}のオブジェクトを新たに作成します。
     * @return {@code ValidateProperty}
     */
    ValidateProperty createValidateProperty(MaintenanceTarget target,
            ReferenceMetaProperty metaProperty);

}
