package jp.sourceforge.masme.target;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import jp.sourceforge.masme.entity.WorkEntity;
import jp.sourceforge.masme.entity.WorkInfo;

public interface MaintenanceWorkTarget extends MaintenanceTarget {

    /**
     * オブジェクトを追加します.
     * 追加時には、与えられた引数でオブジェクトの内容が置き換えられます.
     */
    void add(Serializable id, List<String> propertyNames,
            List<Object> propertyValues);
    /**
     * オブジェクトを追加します.
     */
    void add();

    /**
     * オブジェクトを修正します.
     * 修正時には、与えられた引数でオブジェクトの内容が置き換えられます.
     */
    void edit(List<String> propertyNames, List<Object> propertyValues);
    /**
     * オブジェクトを修正します.
     */
    void edit();

    /**
     * オブジェクトを削除します.
     * 物理削除されたら、trueをそうでなければfalseを返します
     */
    boolean delete();

    /**
     * 修正キャンセルを行います
     * 物理削除されたら、trueをそうでなければfalseを返します
     */
    boolean cancelEdit();

    /**
     * 確認処理を行います
     */
    void confirm();

    /**
     * 確認キャンセルを行います
     */
    void cancelConfirm();

    /**
     * 反映処理を行います
     *
     */
    void reflect();

    /**
     * 反映予定日を設定します
     * @param scheduleDate
     */
    void changeScheduleDate(Date scheduleDate);

    /**
     * ワークエンティティを返却します
     */
    WorkEntity getEntity();

    /**
     * 本番のメンテナンス対象オブジェクトを取得します
     * @return
     */
    MaintenanceRealTarget getRealTarget();

    /**
     * 修正情報を取得します
     * @return
     */
    WorkInfo getWorkInfo();
}
