package jp.sourceforge.masme.target.impl;

import jp.sourceforge.masme.dao.MaintenanceTargetDao;
import jp.sourceforge.masme.meta.MasmenMetaInfo;
import jp.sourceforge.masme.target.MaintenanceTargetFactory;
import jp.sourceforge.masme.target.injection.MaintenanceTargetDaoAware;
import jp.sourceforge.masme.target.injection.MaintenanceTargetFactoryAware;
import jp.sourceforge.masme.target.injection.MasmenMetaInfoAware;
import jp.sourceforge.masme.target.injection.MasmenValidationAware;
import jp.sourceforge.masme.validation.MasmenValidation;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * targetパッケージのオブジェクトに対し、各種プロパティをinjectionして利用できるようにするためのサポートクラス
 */
public abstract class MaintenanceSupport implements MaintenanceTargetDaoAware, MaintenanceTargetFactoryAware, MasmenMetaInfoAware, MasmenValidationAware{
    protected Log log = LogFactory.getLog(this.getClass());

    protected MasmenMetaInfo metaInfo;
    protected MaintenanceTargetDao dao;
    protected MaintenanceTargetFactory factory;
    protected MasmenValidation validation;

    protected void setFromParent(MaintenanceSupport parent) {
        this.setMaintenanceTargetDao(parent.dao);
        this.setMasmenMetaInfo(parent.metaInfo);
        this.setMaintenanceTargetFactory(parent.factory);
        this.setMasmenValidation(parent.validation);
    }

    /**
     * @see jp.sourceforge.masme.target.injection.MaintenanceTargetDaoAware#setMaintenanceTargetDao(jp.sourceforge.masme.dao.MaintenanceTargetDao)
     */
    public void setMaintenanceTargetDao(MaintenanceTargetDao dao) {
        this.dao = dao;
    }

    /**
     * @see jp.sourceforge.masme.target.injection.MaintenanceTargetFactoryAware#setMaintenanceTargetFactory(jp.sourceforge.masme.target.MaintenanceTargetFactory)
     */
    public void setMaintenanceTargetFactory(MaintenanceTargetFactory targetFactory) {
        this.factory =targetFactory;
        
    }

    /**
     * @see jp.sourceforge.masme.target.injection.MasmenMetaInfoAware#setMasmenMetaInfo(jp.sourceforge.masme.meta.MasmenMetaInfo)
     */
    public void setMasmenMetaInfo(MasmenMetaInfo metaInfo) {
        this.metaInfo =metaInfo;
        
    }

    /**
     * @see jp.sourceforge.masme.target.injection.MasmenValidationAware#setMasmenValidation(jp.sourceforge.masme.validation.MasmenValidation)
     */
    public void setMasmenValidation(MasmenValidation validation) {
        this.validation =validation;
    }

}
