package jp.sourceforge.masme.target.impl;

import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.masme.entity.RealEntity;
import jp.sourceforge.masme.entity.WorkEntity;
import jp.sourceforge.masme.entity.WorkInfo;
import jp.sourceforge.masme.meta.MetaProperty;
import jp.sourceforge.masme.meta.ReferenceMetaProperty;
import jp.sourceforge.masme.target.MaintenanceProperty;
import jp.sourceforge.masme.target.MaintenanceTarget;
import jp.sourceforge.masme.target.MaintenanceTargetFactory;
import jp.sourceforge.masme.target.MaintenanceWorkTarget;
import jp.sourceforge.masme.target.ReferenceProperty;
import jp.sourceforge.masme.target.ValidateProperty;

import org.springframework.beans.factory.InitializingBean;

/**
 * 
 *   
 */
public class MaintenanceTargetFactoryImpl extends MaintenanceSupport implements
        MaintenanceTargetFactory, InitializingBean {

    /**
     * @see jp.sourceforge.masme.target.MaintenanceTargetFactory#createMaintenanceTargetEntity(java.lang.Class, jp.sourceforge.masme.entity.WorkEntity)
     */
    public MaintenanceWorkTargetImpl createMaintenanceTargetEntity(Class clazz,
            WorkEntity entity) {
        MaintenanceWorkTargetImpl workTarget = new MaintenanceWorkTargetImpl(
                clazz, entity);
        workTarget.setFromParent(this);
        workTarget.init();
        return workTarget;
    }

    /**
     * @see jp.sourceforge.masme.target.MaintenanceTargetFactory#createMaintenanceTargetEntity(java.lang.Class, jp.sourceforge.masme.entity.RealEntity)
     */
    public MaintenanceRealTargetImpl createMaintenanceTargetEntity(Class clazz,
            RealEntity entity) {
        MaintenanceRealTargetImpl realTarget = new MaintenanceRealTargetImpl(
                clazz, entity);
        realTarget.setFromParent(this);
        realTarget.init();
        return realTarget;
    }

    public List<MaintenanceWorkTarget> createMaintenanceTargetEntity(
            Class clazz, List<WorkEntity> entities) {
        List<MaintenanceWorkTarget> workTargets = new ArrayList<MaintenanceWorkTarget>();

        for (WorkEntity workEntity : entities) {
            workTargets.add(createMaintenanceTargetEntity(clazz, workEntity));
        }

        return workTargets;
    }

    public MaintenanceTarget createMaintenanceTargetEntity(Class clazz) {
        try {
            if (WorkEntity.class.isAssignableFrom(clazz)) {
                Class<WorkEntity> workClass = clazz;
                WorkEntity entity = workClass.newInstance();
                entity.setWorkInfo(new WorkInfo());
                return createMaintenanceTargetEntity(clazz, entity);
            } else {
                Class<RealEntity> realClass = clazz;
                RealEntity entity = realClass.newInstance();
                return createMaintenanceTargetEntity(clazz, entity);
            }
        } catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    /**
     * @see org.springframework.beans.factory.InitializingBean#afterPropertiesSet()
     */
    public void afterPropertiesSet() throws Exception {
        this.setMaintenanceTargetFactory(this);
    }

    /**
     * @see jp.sourceforge.masme.target.MaintenanceTargetFactory#createMaintenanceProperty(jp.sourceforge.masme.target.MaintenanceTarget, jp.sourceforge.masme.meta.MetaProperty)
     */
    public MaintenanceProperty createMaintenanceProperty(MaintenanceTarget target, MetaProperty metaProperty) {
        return new MaintenancePropertyImpl(target, metaProperty);
    }

    /**
     * @see jp.sourceforge.masme.target.MaintenanceTargetFactory#createReferenceProperty(jp.sourceforge.masme.target.MaintenanceTarget, jp.sourceforge.masme.meta.MetaProperty)
     */
    public ReferenceProperty createReferenceProperty(MaintenanceTarget target, MetaProperty metaProperty) {
        return new ReferencePropertyImpl(target, metaProperty);
    }

    /**
     * @see jp.sourceforge.masme.target.MaintenanceTargetFactory#createValidateProperty(jp.sourceforge.masme.target.MaintenanceTarget, jp.sourceforge.masme.meta.MetaProperty)
     */
    public ValidateProperty createValidateProperty(MaintenanceTarget target, ReferenceMetaProperty metaProperty) {
        return new ValidatePropertyImpl(target, metaProperty);
    }


}
