package jp.sourceforge.masme.target.injection;

import jp.sourceforge.masme.dao.MaintenanceTargetDao;
import jp.sourceforge.masme.meta.MasmenMetaInfo;
import jp.sourceforge.masme.target.MaintenanceTargetFactory;
import jp.sourceforge.masme.validation.MasmenValidation;

/**
 * インジェクションを行うための、ユーティリティクラス
 */
public final class MasmenInjectionUtils {

    public static void setMaintenanceTargetDao(Object target,
            MaintenanceTargetDao dao) {
        if (target instanceof MaintenanceTargetDaoAware) {
            MaintenanceTargetDaoAware aware = (MaintenanceTargetDaoAware) target;
            aware.setMaintenanceTargetDao(dao);
        }

    }

    public static void setMaintenanceTargetFactory(Object target,
            MaintenanceTargetFactory factory) {
        if (target instanceof MaintenanceTargetFactoryAware) {
            MaintenanceTargetFactoryAware aware = (MaintenanceTargetFactoryAware) target;
            aware.setMaintenanceTargetFactory(factory);
        }

    }

    public static void setMasmenMetaInfo(Object target, MasmenMetaInfo metaInfo) {
        if (target instanceof MasmenMetaInfoAware) {
            MasmenMetaInfoAware aware = (MasmenMetaInfoAware) target;
            aware.setMasmenMetaInfo(metaInfo);
        }

    }

    public static void setMasmenValidation(Object target,
            MasmenValidation validation) {
        if (target instanceof MasmenValidationAware) {
            MasmenValidationAware aware = (MasmenValidationAware) target;
            aware.setMasmenValidation(validation);
        }

    }

}
