package jp.sourceforge.masme.util.impl;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class SimpleDateUtils {
    public static final String FORMAT = "yyyy/MM/dd";
    static DateFormat dateFormat = new SimpleDateFormat(FORMAT);

    public static Date stringToDate(String str) {
        try {
            return dateFormat.parse(str);
        } catch (ParseException ex) {
            throw new IllegalArgumentException("[" + str + "] is not format["
                    + FORMAT + "]", ex);
        }
    }

    public static String dateToString(Date date) {
        return dateFormat.format(date);
    }

    public static Date getTime(int year, int month, int date) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month, date);
        return cal.getTime();
    }

}
