package jp.sourceforge.masme;

import java.io.Serializable;
import java.util.Date;

import jp.sourceforge.masme.entity.WorkInfo;
import jp.sourceforge.masme.test.entity.Company;
import jp.sourceforge.masme.test.entity.CompanyWork;
import jp.sourceforge.masme.test.entity.Customer;
import jp.sourceforge.masme.test.entity.CustomerWork;
import jp.sourceforge.masme.util.impl.SimpleDateUtils;

import org.jmock.MockObjectTestCase;

public abstract class MasmenMockTestSupport extends MockObjectTestCase {

    public static Date BEFORE_DATE = SimpleDateUtils.getTime(2008, 12, 1);
    public static Date AFTER_DATE = SimpleDateUtils.getTime(2008, 12, 15);

    public static CustomerWork createCustomerWork() {
        CustomerWork entity = createCustomerWork("1");
        return entity;
    }

    public static CustomerWork createCustomerWork(Serializable id) {
        CustomerWork entity = new CustomerWork();
        entity.setId(id);
        entity.setName("testCustomer");
        entity.setState("JP");
        entity.setWorkInfo(new WorkInfo());
        return entity;
    }

    public static CompanyWork createCompanyWork() {
        CompanyWork entity = createCompanyWork("1");
        return entity;
    }

    public static CompanyWork createCompanyWork(String id) {
        CompanyWork entity = new CompanyWork();
        entity.setId(id);
        entity.setName("testCompany");
        entity.setWorkInfo(new WorkInfo());
        return entity;
    }

    public static Company createCompany() {
        Company entity = createCompany("1");
        return entity;
    }

    public static Company createCompany(String id) {
        Company entity = new Company();
        entity.setId(id);
        entity.setName("testCompany");
        return entity;
    }

    public static Customer createCustomer() {
        Customer entity = createCustomer("1");
        return entity;
    }

    public static Customer createCustomer(Serializable id) {
        Customer entity = new Customer();
        entity.setId(id);
        entity.setName("testCustomer");
        entity.setState("JP");
        return entity;
    }
}
