package jp.sourceforge.masme.meta;

import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.masme.meta.AnnotationMetaInfoFactoryBean;
import jp.sourceforge.masme.meta.MasmenMetaInfo;
import jp.sourceforge.masme.meta.MetaClass;
import jp.sourceforge.masme.meta.MetaProperty;
import jp.sourceforge.masme.meta.ReferenceMetaProperty;
import jp.sourceforge.masme.test.entity.Company;
import jp.sourceforge.masme.test.entity.CompanyWork;
import jp.sourceforge.masme.test.entity.Customer;
import jp.sourceforge.masme.test.entity.CustomerWork;
import jp.sourceforge.masme.validation.impl.MethodValidateFunctionFactory;

import org.jmock.MockObjectTestCase;

public class AnnotationMetaInfoFactoryBeanTest extends MockObjectTestCase {

    private AnnotationMetaInfoFactoryBean factoryBean;

    @Override
    public void setUp() {
        factoryBean = new AnnotationMetaInfoFactoryBean();
        MethodValidateFunctionFactory validateFunctionFactory = new MethodValidateFunctionFactory();
        factoryBean.setValidateFunctionFactory(validateFunctionFactory);
    }

    public void test取得() throws Exception {
        List<String> clsNames = new ArrayList<String>();
        clsNames.add(Customer.class.getName());
        clsNames.add(Company.class.getName());
        factoryBean.setAnnotatedMaintenanceClassNames(clsNames);
        factoryBean.afterPropertiesSet();
        MasmenMetaInfo metaInfo = (MasmenMetaInfo) factoryBean.getObject();

        List<MetaClass> metaClasses = metaInfo.getMetaClasses();
        assertEquals(2, metaClasses.size());
        // customerクラス の検証
        MetaClass customerMetaClass = metaClasses.get(0);
        assertEquals("id", customerMetaClass.getIdName());
        assertEquals(CustomerWork.class, customerMetaClass.getWorkClass());
        assertEquals(Customer.class, customerMetaClass.getRealClass());
        assertEquals(0, customerMetaClass.getReferenceMetaProperties().size());
        List<MetaProperty> customerMetaProperties = customerMetaClass
                .getMetaProperties();
        assertEquals(4, customerMetaProperties.size());
        // companyプロパティの検証
        assertEquals(customerMetaClass, customerMetaProperties.get(0)
                .getMetaClass());
        assertEquals("company", customerMetaProperties.get(0).getPropertyName());
        assertEquals(Company.class, customerMetaProperties.get(0)
                .getPropertyType());
        ReferenceMetaProperty rMetaProperty = (ReferenceMetaProperty) customerMetaProperties
                .get(0);
        assertEquals("companyWork", rMetaProperty.getWorkPropertyName());
        assertEquals("customers", rMetaProperty.getReferencedPropertyName());
        assertEquals("customerWorks", rMetaProperty
                .getWorkReferencedPropertyName());
        assertEquals(metaClasses.get(1), rMetaProperty.getReferenceMetaClass());
        //nullableCompnayの検証はしない
        // その他のプロパティの検証
        assertEquals("name", customerMetaProperties.get(1).getPropertyName());
        assertEquals(String.class, customerMetaProperties.get(1)
                .getPropertyType());
        assertEquals("state", customerMetaProperties.get(3).getPropertyName());
        assertEquals(String.class, customerMetaProperties.get(3)
                .getPropertyType());
        // comanyクラス の検証
        MetaClass companyMetaClass = metaClasses.get(1);
        assertEquals("id", companyMetaClass.getIdName());
        assertEquals(CompanyWork.class, companyMetaClass.getWorkClass());
        assertEquals(Company.class, companyMetaClass.getRealClass());
        assertEquals(2, companyMetaClass.getReferenceMetaProperties().size());
        assertEquals(rMetaProperty, companyMetaClass
                .getReferenceMetaProperties().get(0));
        // プロパティの検証
        List<MetaProperty> companyProperties = companyMetaClass
                .getMetaProperties();
        assertEquals("name", companyProperties.get(0).getPropertyName());
        assertEquals(String.class, companyProperties.get(0).getPropertyType());

    }

}
