package jp.sourceforge.masme.target.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import jp.sourceforge.masme.MasmenMockTestSupport;
import jp.sourceforge.masme.dao.MaintenanceTargetDao;
import jp.sourceforge.masme.entity.MaintenanceEntity;
import jp.sourceforge.masme.target.MaintenanceProperty;
import jp.sourceforge.masme.target.MaintenanceTarget;
import jp.sourceforge.masme.target.MaintenanceWorkTarget;
import jp.sourceforge.masme.target.ReferenceProperty;
import jp.sourceforge.masme.target.ValidateProperty;
import jp.sourceforge.masme.target.impl.MaintenanceTargetFactoryImpl;
import jp.sourceforge.masme.test.entity.CompanyWork;
import jp.sourceforge.masme.test.entity.CustomerWork;
import jp.sourceforge.masme.validation.ValidationResult;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class MaintenanceTargetFactoryImplTest extends MasmenMockTestSupport {
    MaintenanceTargetFactoryImpl factory;

    CustomerWork customerWork;

    CompanyWork companyWork;

    @Override
    public void setUp() {
        customerWork = createCustomerWork();
        companyWork = createCompanyWork();
        customerWork.setCompanyWork(companyWork);
        companyWork.getCustomerWorks().add(customerWork);
        factory = createFactory();
    }

    public static MaintenanceTargetFactoryImpl createFactory() {
        String ctxFileName = MaintenanceTargetFactoryImplTest.class.getName()
                .replaceAll("\\.", "/")
                + ".xml";
        ApplicationContext context = new ClassPathXmlApplicationContext(
                ctxFileName);

        MaintenanceTargetFactoryImpl factory = (MaintenanceTargetFactoryImpl) context
                .getBean("MaintenanceTargetFactory");
        factory.setMaintenanceTargetDao(new MaintenanceTargetDaoImpl());
        return factory;
    }

    public void testWorkクラス作成() {
        MaintenanceTarget workTarget = factory.createMaintenanceTargetEntity(
                CustomerWork.class, customerWork);
        Serializable id = workTarget.getId();
        assertEquals("1", id);
    }

    public void test_MaintenanceProperty() {
        MaintenanceTarget workTarget = factory.createMaintenanceTargetEntity(
                CustomerWork.class, customerWork);

        List<MaintenanceProperty> mps = workTarget.getMaintenanceProperties();
        assertEquals(4, mps.size());
        // company property
        assertTrue(mps.get(0) instanceof ReferenceProperty);
        assertEquals("company", mps.get(0).getPropertyName());
        assertEquals("1", mps.get(0).getPropertyValue());
        // name property
        assertEquals("name", mps.get(1).getPropertyName());
        assertEquals("testCustomer", mps.get(1).getPropertyValue());
        // nullableCompany property
        assertEquals("nullableCompany", mps.get(2).getPropertyName());
        assertEquals(null, mps.get(2).getPropertyValue());
        // state property
        assertEquals("state", mps.get(3).getPropertyName());
        assertEquals("JP", mps.get(3).getPropertyValue());

    }

    public void test_ValidateProperty_customer() {
        MaintenanceTarget workTarget = factory.createMaintenanceTargetEntity(
                CustomerWork.class, customerWork);

        List<ValidateProperty> vps = workTarget.getValidateProperties();
        assertEquals(0, vps.size());
    }

    public void test_ValidateProperty_company() {
        MaintenanceTarget workTarget = factory.createMaintenanceTargetEntity(
                CompanyWork.class, companyWork);

        List<ValidateProperty> vps = workTarget.getValidateProperties();
        assertEquals(2, vps.size());
        // company property
        assertEquals(true, vps.get(0).isNonDeletedProperty());
        ValidationResult result = vps.get(0).invokeWorkValidateMethod(
                (MaintenanceWorkTarget) workTarget);
        assertTrue("object[" + result + "] is not fail", result
                .validationSuccess());
    }

    public void test_ValidateProperty_company_validateFail() {
        companyWork.setName("test");
        customerWork.setName("test");
        MaintenanceTarget workTarget = factory.createMaintenanceTargetEntity(
                CompanyWork.class, companyWork);

        List<ValidateProperty> vps = workTarget.getValidateProperties();
        assertEquals(2, vps.size());
        // company property
        assertEquals(true, vps.get(0).isNonDeletedProperty());
        ValidationResult result = vps.get(0).invokeWorkValidateMethod(
                (MaintenanceWorkTarget) workTarget);
        assertFalse("object[" + result + "] is not fail", result
                .validationSuccess());
    }

    private static class MaintenanceTargetDaoImpl implements
            MaintenanceTargetDao {
        public void delete(Object obj) {
        }

        public MaintenanceEntity get(Class targetClass, Serializable key) {
            return createCustomerWork();
        }

        public List loadAll(Class targetClass) {
            return new ArrayList();
        }

        public List loadEditAll(Class targetClass) {
            return new ArrayList();
        }

        public List loadWaitReflectAll(Class targetClass, Date reflectDate) {
            return new ArrayList();
        }

        public Serializable save(Object obj) {
            return createCustomerWork().getId();
        }

        public void update(Object obj) {
        }
    }

}
