package jp.sourceforge.masme.target.impl;

import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.masme.MasmenValidateException;
import jp.sourceforge.masme.dao.MaintenanceTargetDao;
import jp.sourceforge.masme.entity.ReflectState;
import jp.sourceforge.masme.entity.WorkInfo;
import jp.sourceforge.masme.target.impl.MaintenanceTargetFactoryImpl;
import jp.sourceforge.masme.target.impl.MaintenanceWorkTargetImpl;
import jp.sourceforge.masme.test.entity.CompanyWork;
import jp.sourceforge.masme.test.entity.CustomerWork;


import org.jmock.Mock;
import org.jmock.MockObjectTestCase;

public class MaintenanceWorkTargetImplTest extends MockObjectTestCase {
    MaintenanceWorkTargetImpl target;
    Mock daoMock;

    MaintenanceTargetFactoryImpl factory = MaintenanceTargetFactoryImplTest
            .createFactory();

    @Override
    public void setUp() {
        daoMock = mock(MaintenanceTargetDao.class);
        factory.setMaintenanceTargetDao((MaintenanceTargetDao) daoMock.proxy());
        target = (MaintenanceWorkTargetImpl) factory
                .createMaintenanceTargetEntity(CustomerWork.class,
                        createCustomerWork());
    }

    public void test_edit() {
        List<String> propertyNames = new ArrayList<String>();
        List<Object> propertyValues = new ArrayList<Object>();
        propertyNames.add("name");
        propertyValues.add("MyName");
        propertyNames.add("state");
        propertyValues.add("JP");
        propertyNames.add("company");
        propertyValues.add("1");
        // set dao mock
        daoMock.stubs().method("update").with(eq(target.getEntity())).isVoid();
        daoMock.expects(once()).method("get").with(eq(CompanyWork.class),
                eq("1")).will(returnValue(createCompanyWork()));

        target.edit(propertyNames, propertyValues);

        CustomerWork customerWork = (CustomerWork) target.getEntity();

        assertEquals("MyName", customerWork.getName());
        assertEquals("JP", customerWork.getState());
        assertEquals(null, customerWork.getCompany());
        assertEquals(createCompanyWork(), customerWork.getCompanyWork());

        assertEquals(ReflectState.EDITED, customerWork.getWorkInfo()
                .getReflectState());
    }

    public void test_add() {
        target = (MaintenanceWorkTargetImpl) factory
                .createMaintenanceTargetEntity(CustomerWork.class);
        List<String> propertyNames = new ArrayList<String>();
        List<Object> propertyValues = new ArrayList<Object>();
        // set dao mock
        daoMock.stubs().method("save").with(eq(target.getEntity())).isVoid();
        daoMock.expects(once()).method("get").with(eq(CustomerWork.class),
                eq("1")).will(returnValue(null));
        
        // company
        propertyNames.add("name");
        propertyValues.add("any_name");
        propertyNames.add("company");
        propertyValues.add("3");
        daoMock.expects(once()).method("get").with(eq(CompanyWork.class),
                eq("3")).will(returnValue(createCompanyWork()));

        target.add("1", propertyNames, propertyValues);

        CustomerWork customerWork = (CustomerWork) target.getEntity();

        assertEquals("1", customerWork.getId());
        assertEquals(ReflectState.EDITED, customerWork.getWorkInfo()
                .getReflectState());

    }

    public void test_add_fail() {
        target = (MaintenanceWorkTargetImpl) factory
                .createMaintenanceTargetEntity(CustomerWork.class);
        List<String> propertyNames = new ArrayList<String>();
        List<Object> propertyValues = new ArrayList<Object>();
        // set dao mock
        daoMock.stubs().method("save").with(eq(target.getEntity())).isVoid();
        daoMock.expects(once()).method("get").with(eq(CustomerWork.class),
                eq("1")).will(returnValue(createCustomerWork()));
        try {
            target.add("1", propertyNames, propertyValues);
            fail();
        } catch (MasmenValidateException e) {
            System.out.println(e);
        }

    }

    private static CustomerWork createCustomerWork() {
        CustomerWork work = new CustomerWork();
        work.setId("1");
        work.setName("test");
        work.setState("JP");
        work.setWorkInfo(new WorkInfo());
        return work;
    }

    private static CompanyWork createCompanyWork() {
        CompanyWork work = new CompanyWork();
        work.setId("1");
        work.setName("test");
        work.setWorkInfo(new WorkInfo());
        return work;
    }

}
