package jp.sourceforge.masme.target.impl;

import java.io.Serializable;

import jp.sourceforge.masme.dao.MaintenanceTargetDao;
import jp.sourceforge.masme.entity.WorkInfo;
import jp.sourceforge.masme.target.impl.MaintenanceTargetFactoryImpl;
import jp.sourceforge.masme.target.impl.MaintenanceWorkTargetImpl;
import jp.sourceforge.masme.target.impl.ReferencePropertyImpl;
import jp.sourceforge.masme.test.entity.CompanyWork;
import jp.sourceforge.masme.test.entity.CustomerWork;

import org.jmock.Mock;
import org.jmock.MockObjectTestCase;

public class ReferencePropertyImplTest extends MockObjectTestCase {
    ReferencePropertyImpl reProperty;
    Mock daoMock;

    MaintenanceTargetFactoryImpl factory = MaintenanceTargetFactoryImplTest
            .createFactory();

    @Override
    public void setUp() {
        daoMock = mock(MaintenanceTargetDao.class);
        factory.setMaintenanceTargetDao((MaintenanceTargetDao) daoMock.proxy());
        MaintenanceWorkTargetImpl target = (MaintenanceWorkTargetImpl) factory
                .createMaintenanceTargetEntity(CustomerWork.class,
                        createCustomerWork());
        reProperty = (ReferencePropertyImpl) target.getMaintenanceProperties()
                .get(0);
    }

    public void test_getProperty() {
        Serializable companyId = reProperty.getPropertyValue();
        assertEquals("10", companyId);
    }

    public void test_getProperty_null() {
        CustomerWork customerWork = createCustomerWork();
        customerWork.setCompanyWork(null);
        MaintenanceWorkTargetImpl target = (MaintenanceWorkTargetImpl) factory
                .createMaintenanceTargetEntity(CustomerWork.class, customerWork);
        reProperty = (ReferencePropertyImpl) target.getMaintenanceProperties()
                .get(0);
        Serializable companyId = reProperty.getPropertyValue();
        assertEquals(null, companyId);
    }

    public void test_setProperty() {
        CompanyWork retCompanyWork = createCompanyWork();
        retCompanyWork.setId("80");
        daoMock.expects(once()).method("get").with(eq(CompanyWork.class),
                eq("80")).will(returnValue(retCompanyWork));
        reProperty.setPropertyValue("80");
        assertEquals("80", reProperty.getPropertyValue());
    }

    public void test_setProperty_null() {
        CompanyWork retCompanyWork = createCompanyWork();
        retCompanyWork.setId(null);
        daoMock.expects(once()).method("get").with(eq(CompanyWork.class),
                eq("80")).will(returnValue(retCompanyWork));
        reProperty.setPropertyValue("80");
        assertEquals(null, reProperty.getPropertyValue());
    }

    private static CustomerWork createCustomerWork() {
        CustomerWork work = new CustomerWork();
        work.setId("1");
        work.setName("test");
        work.setState("JP");
        work.setWorkInfo(new WorkInfo());
        work.setCompanyWork(createCompanyWork());
        return work;
    }

    private static CompanyWork createCompanyWork() {
        CompanyWork work = new CompanyWork();
        work.setId("10");
        work.setName("test");
        work.setWorkInfo(new WorkInfo());
        return work;
    }

}
