package jp.sourceforge.masme.test.entity;

import java.util.Set;

import javax.persistence.Id;

import jp.sourceforge.masme.annotation.MaintenanceTargetProperty;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

/** @author Hibernate CodeGenerator */
public abstract class AbstractCompany {

    private String id;
    private String name;
    private Set<Customer> customers;
    private Set<Customer> nullableCustomers;

    public String toString() {
        return new ToStringBuilder(this).append("id", getId()).append("name",
                getName()).toString();
    }

    public boolean equals(Object other) {
        if ((this == other))
            return true;
        if (!(other instanceof AbstractCompany))
            return false;
        AbstractCompany castOther = (AbstractCompany) other;
        return new EqualsBuilder().append(this.getId(), castOther.getId())
                .isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(getId()).toHashCode();
    }

    public Set<Customer> getCustomers() {
        return customers;
    }

    public void setCustomers(Set<Customer> customers) {
        this.customers = customers;
    }

    @Id
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @MaintenanceTargetProperty
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
//
//    Pattern namePatten = Pattern.compile("[a-zA-Z0-9]*");
//
//    public void validate() {
//        Matcher match = namePatten.matcher(name);
//        if (!match.matches()) {
//            throw new MasmenValidateException("name(" + name + ") not match "
//                    + namePatten.pattern());
//        }
//    }

    public Set<Customer> getNullableCustomers() {
        return nullableCustomers;
    }

    public void setNullableCustomers(Set<Customer> nullablecustomers) {
        this.nullableCustomers = nullablecustomers;
    }


}
