package jp.sourceforge.masme.validation.drools;

import jp.sourceforge.masme.MasmenValidateException;
import jp.sourceforge.masme.entity.MaintenanceEntity;
import jp.sourceforge.masme.validation.ValidateFunction;

import org.drools.KnowledgeBase;
import org.drools.runtime.StatelessKnowledgeSession;

/**
 * 
 * Droolsを使った{@code ValidateFunction}の実装クラス
 */
public class DroolsValidateFunction implements ValidateFunction {
    private KnowledgeBase knowledgeBase;

    public void setKnowledgeBase(KnowledgeBase kbase) {
        this.knowledgeBase = kbase;
    }

    /**
     * @see jp.sourceforge.masme.validation.ValidateFunction#invoke(jp.sourceforge.masme.entity.MaintenanceEntity, jp.sourceforge.masme.entity.MaintenanceEntity)
     */
    public void invoke(MaintenanceEntity target, MaintenanceEntity other) {

        StatelessKnowledgeSession ksession = knowledgeBase.newStatelessKnowledgeSession();
        DroolsTargetObject object = new DroolsTargetObject();
        object.setTarget(target);
        object.setOther(other);
        ksession.execute(object);
        if (!object.isValid()) {
            throw new MasmenValidateException(object.getMessage());
        }
 
    }

    /**
     * @see jp.sourceforge.masme.validation.ValidateFunction#invoke(jp.sourceforge.masme.entity.MaintenanceEntity)
     */
    public void invoke(MaintenanceEntity target) {
        invoke(target, null);
    }
}
