/**
 * 
 */
package jp.sourceforge.masme.validation.drools;

import java.util.HashMap;
import java.util.Map;

import jp.sourceforge.masme.MasmenValidateException;
import jp.sourceforge.masme.meta.ReferenceMetaProperty;
import junit.framework.TestCase;

/**
 *
 */
public class DroolsValidateFunctionTest extends TestCase {
    private DroolsValidateFunctionFactory functionFactory;
    
    @Override
    public void setUp() {
        functionFactory = new DroolsValidateFunctionFactory();
        Map<String, String> map = new HashMap<String, String>();
        map.put("rule", "./TestRule.drl");
        functionFactory.setDrlResourceMap(map);
    }

    public void testSuccessInvoke() {
        ReferenceMetaProperty meta = new ReferenceMetaProperty("","","","","rule",null,null){};
        DroolsValidateFunction function = functionFactory.createValidateFunction(meta);
        assertNotNull(function);

        TestEntity next = createTestEntity(1, "next", null);
        TestEntity target = createTestEntity(2, "target", next);
        function.invoke(target, next);
    }
    public void testErrorInvoke() {
        ReferenceMetaProperty meta = new ReferenceMetaProperty("","","","","rule",null,null){};
        DroolsValidateFunction function = functionFactory.createValidateFunction(meta);
        assertNotNull(function);

        TestEntity target = createTestEntity(2, "target", null);
        try{
        function.invoke(target, null);
        fail();
        } catch(MasmenValidateException ex){
            //test success
        }
    }
    
    private static TestEntity createTestEntity(long id, String name, TestEntity next){
        TestEntity entity = new TestEntity();
        entity.setId(id);
        entity.setName(name);
        entity.setNext(next);
        return entity;
    }

}
