package jp.sourceforge.masme.samples.standalone.entity;

import java.util.Set;

import javax.persistence.Id;

import jp.sourceforge.masme.MasmenValidateException;
import jp.sourceforge.masme.annotation.MaintenanceTargetProperty;
import jp.sourceforge.masme.annotation.ReferenceTargetProperty;

import org.apache.commons.collections.set.ListOrderedSet;

public abstract class AbstractCourse {
	private long id;
	private String name;
	private Teacher teacher;
    private Subject subject;
	private Set<AbstractStudent> students = new ListOrderedSet();
    
    public AbstractCourse() {
        
    }
    public AbstractCourse(long id, String name,Subject subject) {
        this.id = id;
        this.name = name;
        this.subject = subject;
    }
    
    
	public Set<AbstractStudent> getStudents() {
		return students;
	}
	public void setStudents(Set<AbstractStudent> students) {
		this.students = students;
	}
    @MaintenanceTargetProperty(referenceTarget = 
    { @ReferenceTargetProperty(workPropertyName = "teacherWork", referencePropertyName = "courses", workReferencePropertyName = "courseWorks", validationMethodName = "validateForTeacher") })
	public Teacher getTeacher() {
		return teacher;
	}
	public void setTeacher(Teacher teacher) {
		this.teacher = teacher;
	}
	@Id
	public long getId() {
		return id;
	}
	public void setId(long id) {
		this.id = id;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
    
    public Subject getSubject() {
        return subject;
    }
    public void setSubject(Subject subject) {
        this.subject = subject;
    }
    public void validateForTeacher(AbstractTeacher teacher) {
        if (teacher == null) {
            throw new MasmenValidateException("teacher is not found.");
        }
        if (!teacher.getSubjects().contains(this.subject)){
            throw new MasmenValidateException("Teacher[" + teacher+"] cannot teach ["+this.subject+"]");
        }
    }
	

}
