package jp.sourceforge.masme.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.sourceforge.masme.MasmenValidateException;
import jp.sourceforge.masme.service.ConfirmTargetService;
import jp.sourceforge.masme.target.MaintenanceWorkTarget;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

public class CancelConfirmAction extends Action {

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception {
        MaintenanceWorkTarget target = (MaintenanceWorkTarget) request
                .getSession().getAttribute("maintenanceTarget");
        try {
            service.cancelConfirm(target);
        } catch (MasmenValidateException ex) {
            // バリデーション処理失敗時にエラーメッセージを表示する
            ActionMessages ms = new ActionMessages();
            ActionMessage m = new ActionMessage(ex.getMessage(), false);
            ms.add(ActionMessages.GLOBAL_MESSAGE, m);
            saveErrors(request, ms);
            return mapping.findForward("retry");
        }

        return mapping.findForward("success");
    }

    /** このアクションで利用するサービス */
    private ConfirmTargetService service;

    /**
     * @param service
     *            このアクションで利用するサービス
     */
    public void setService(ConfirmTargetService service) {
        this.service = service;
    }
}
