package jp.sourceforge.masme.action;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.sourceforge.masme.entity.WorkEntity;
import jp.sourceforge.masme.service.LoadTargetService;
import jp.sourceforge.masme.target.MaintenanceWorkTarget;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class LoadAllAction extends Action {

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception {

        Class<WorkEntity> targetClass = (Class<WorkEntity>) request
                .getSession().getAttribute("targetClass");

        List<MaintenanceWorkTarget> targets = service.loadAll(targetClass);
        request.setAttribute("entities", targets);

        return mapping.findForward("success");
    }

    /** このアクションで利用するサービス */
    private LoadTargetService service;

    /**
     * @param service
     *            このアクションで利用するサービス
     */
    public void setService(LoadTargetService service) {
        this.service = service;
    }
}
