package jp.sourceforge.masme.action;

import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.sourceforge.masme.entity.WorkEntity;
import jp.sourceforge.masme.service.LoadTargetService;
import jp.sourceforge.masme.target.MaintenanceWorkTarget;
import jp.sourceforge.masme.util.impl.SimpleDateUtils;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.validator.DynaValidatorForm;

public class ReflectInitAction extends Action {

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception {

        DynaValidatorForm dynaForm = (DynaValidatorForm) form;
        Class<WorkEntity> targetClass = (Class<WorkEntity>) request
                .getSession().getAttribute("targetClass");

        String reflectDateStr = (String) dynaForm.get("reflectDate");
        Date reflectDate = null;
        if (!StringUtils.isEmpty(reflectDateStr)) {
            reflectDate = SimpleDateUtils.stringToDate(reflectDateStr);
        }

        List<MaintenanceWorkTarget> targets = service.loadWaitReflectAll(
                targetClass, reflectDate);
        request.setAttribute("entities", targets);

        return mapping.findForward("success");
    }

    /** このアクションで利用するサービス */
    private LoadTargetService service;

    /**
     * @param service
     *            このアクションで利用するサービス
     */
    public void setService(LoadTargetService service) {
        this.service = service;
    }
}
