package jp.sourceforge.masme.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.validator.DynaValidatorForm;

public class SelectTargetClassAction extends Action {

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception {
        DynaValidatorForm dynaForm = (DynaValidatorForm) form;
        String targetClassName = dynaForm.getString("targetClassName");
        // if no target class then return
        if (StringUtils.isEmpty(targetClassName)) {
            return mapping.findForward("success");
        }
        Class targetClass;
        try {
            targetClass = Class.forName(targetClassName);
        } catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("target class name["
                    + targetClassName + "] not found", e);
        }

        request.getSession().setAttribute("targetClass", targetClass);

        return mapping.findForward("success");
    }
}
