// sample01.cpp

#include <windows.h>
#include "resource.h"
#include <commctrl.h>
#include <cctype>
#include "fparser.h"
#pragma comment(lib, "comctl32.lib")


HINSTANCE hInst;

ATOM InitApp(HINSTANCE);
BOOL InitInstance(HINSTANCE, int);
HWND ToolBarCreate(HWND hWnd);
HWND StatusbarCreate(HWND hWnd);
BOOL CheckString(char *buff);

LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);

char lpClassName[] = "graphviewr";	//EBhENX


int WINAPI WinMain(HINSTANCE hCurInst, HINSTANCE hPrevInst,
				   LPSTR lpsCmdLine, int nCmdShow)
{
	MSG msg;
	BOOL bRet;
	hInst = hCurInst;
	
	if (!InitApp(hCurInst))
		return FALSE;
	if (!InitInstance(hCurInst, nCmdShow)) 
		return FALSE;
	while ((bRet = GetMessage(&msg, NULL, 0, 0)) != 0) {
		if (bRet == -1) {
			break;
		} else {
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}
	return (int)msg.wParam;
}

//EBhEENX̓o^

ATOM InitApp(HINSTANCE hInst)
{
	WNDCLASSEX wc;
	wc.cbSize = sizeof(WNDCLASSEX);
	wc.style = CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc = WndProc;	//vV[W
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hInstance = hInst;//CX^X
	wc.hIcon = (HICON)LoadImage(NULL,
		MAKEINTRESOURCE(IDI_APPLICATION),
		IMAGE_ICON,
		0,
		0,
		LR_DEFAULTSIZE | LR_SHARED);
	wc.hCursor = (HCURSOR)LoadImage(NULL,
		MAKEINTRESOURCE(IDC_ARROW),
		IMAGE_CURSOR,
		0,
		0,
		LR_DEFAULTSIZE | LR_SHARED);
	wc.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
	wc.lpszMenuName =NULL;
	wc.lpszClassName = (LPCSTR)lpClassName;
	wc.hIconSm = (HICON)LoadImage(NULL,
		MAKEINTRESOURCE(IDI_APPLICATION),
		IMAGE_ICON,
		0,
		0,
		LR_DEFAULTSIZE | LR_SHARED);

	return (RegisterClassEx(&wc));
}

//EBhE̐

BOOL InitInstance(HINSTANCE hInst, int nCmdShow)
{
	HWND hWnd;

	hWnd = CreateWindow(lpClassName,
			"2D֐Otr[A[", //^Cgo[ɂ̖O\܂
			WS_OVERLAPPEDWINDOW, //EBhE̎
			CW_USEDEFAULT,	//wW
			CW_USEDEFAULT,	//xW
			CW_USEDEFAULT,	//
			CW_USEDEFAULT,	//
			NULL, //eEBhẼnhAeƂNULL
			NULL, //j[nhANXj[gƂNULL
			hInst, //CX^Xnh
			NULL);
	if (!hWnd)
		return FALSE;
	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);
	return TRUE;
}

//EBhEvV[W

LRESULT CALLBACK WndProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	static HWND hToolBar,StaticText,EditBox,Button,hStatus;
	FunctionParser fparser;
	fparser.AddConstant("pi", 3.1415926535897932);
	static std::string function;
	char buff[255]={'\0'};
	char points[256] = {'\0'};
	double  mag = 10;    // mag = g嗦
    int px, py;
	PAINTSTRUCT ps;
	POINT point;
    HDC hdc;
	RECT rct;
	HPEN hPen,hOldPen;
	HPEN hGPen,hGOldPen;
	int ox, oy;
	int wmId, wmEvent;
	int res;
    double vals[1] = { 0 };
    //static UINT uToolStyle;

	switch (msg) {
		
		case WM_CREATE:
			//c[o[
			hToolBar = ToolBarCreate( hWnd );
			//c[o[Ƀ{^ǉ
			//ToolBarAddButtons( 3, tbb );
			StaticText = CreateWindowExA(
                0,                //gX^CȂ
                "STATIC", // NXl[
				"f(x)=",             //EBhE^Cg
                 SS_SIMPLE | WS_CHILD | WS_VISIBLE,     //EBhEX^C
                0, 5,             //EBhEʒu
                (int)strlen("f(x)=")*10, 16,         //EBhEA
                hWnd,             //eEBhE
                (HMENU)IDM_STATIC,  //Rg[ʎq
                hInst,            //CX^Xnh
                NULL);            //pointer to window-creation data 

            
            SendMessage(StaticText, IDM_STATIC, (WPARAM)sizeof(StaticText), 0);
			
			
			EditBox = CreateWindowA(
                               //gX^CȂ
                "EDIT", // NXl[
				NULL,             //EBhE^Cg
				WS_CHILD | WS_VISIBLE  ,     //EBhEX^C
                40, 5,             //EBhEʒu
                400, 16,         //EBhEA
                hWnd,             //eEBhE
                (HMENU)IDM_EDIT,  //Rg[ʎq
                hInst,            //CX^Xnh
                NULL);            //pointer to window-creation data 
			Button = CreateWindowExA(
                0,                //gX^CȂ
                "BUTTON", // NXl[
				"plot",             //EBhE^Cg
				ES_LEFT | WS_CHILD | WS_VISIBLE ,     //EBhEX^C
                450, 5,             //EBhEʒu
                50, 20,         //EBhEA
                hWnd,             //eEBhE
                (HMENU)IDM_BUTTON,  //Rg[ʎq
                hInst,            //CX^Xnh
                NULL);            //pointer to window-creation data 
			SetParent(StaticText,hToolBar);
			SetParent(EditBox,hToolBar);
			SetParent(Button,hToolBar);
			SendMessage(EditBox,EM_LIMITTEXT,255,0);
			
            hStatus = StatusbarCreate(hWnd);
			SendMessageA(hStatus,SB_SIMPLE,0,0);
			
			InvalidateRect(hToolBar, NULL, TRUE);
			InvalidateRect(EditBox, NULL, TRUE);
			
			break;
		case WM_SETFOCUS:
			SetFocus(EditBox);
			break;
		
		case WM_SIZE:
			MoveWindow(hToolBar, 0, 0, LOWORD(lp), 32, TRUE);
			SendMessage(hToolBar, WM_SIZE, wp, lp);
			SendMessage(hStatus, msg, wp, lp);
			
			break;
		case WM_COMMAND:
			wmId    = LOWORD(wp);
			wmEvent = HIWORD(wp);
			// Iꂽj[̉:
			switch (wmId)
			{
				case IDM_BUTTON:
					
					GetWindowText(EditBox,buff,sizeof(buff)-1);
					if(FALSE==CheckString(buff)){
						MessageBoxA(hWnd,"͕sł","G[",MB_OK);
						break;
					}
			
					function = buff;
					res = fparser.Parse(function, "x");
					if(res>=0){
						MessageBoxA(hWnd,fparser.ErrorMsg(),"G[bZ[W",MB_OK);
						break;
					}
					InvalidateRect(hWnd,NULL,TRUE);
					break;
			}
		case WM_PAINT:
			
            hdc = BeginPaint(hWnd, &ps);
			
			
            // TODO: `R[hɒǉĂ...
			GetClientRect(hWnd,&rct);

			
			ox = rct.right/2;
			oy = rct.bottom/2;

			hPen = CreatePen(PS_SOLID,1,RGB(0,0,0));
			hOldPen = (HPEN)SelectObject(hdc,hPen);
			MoveToEx(hdc,0, oy,NULL);
			LineTo(hdc,2*ox, oy);
			MoveToEx(hdc,ox,0,NULL);
			LineTo(hdc,ox, 2*oy);

			DeleteObject(hPen);
			SelectObject(hdc,hOldPen);

			hPen = CreatePen(PS_DOT,1,RGB(0,0,0));
			hOldPen = (HPEN)SelectObject(hdc,hPen);

			for(int x = ox-(int)mag ; x >= 0; x-=(int)mag){
				MoveToEx(hdc,x, 0,NULL);
				LineTo(hdc,x,rct.bottom);
			}
			for(int x = ox+(int)mag ; x <= rct.right; x+=(int)mag){
				MoveToEx(hdc,x, 0,NULL);
				LineTo(hdc,x,rct.bottom);
			}
			for(int y = oy-(int)mag ; y >= 0; y-=(int)mag){
				MoveToEx(hdc,0, y,NULL);
				LineTo(hdc,rct.right,y);
			}
			for(int y = oy+(int)mag ; y <= rct.bottom; y+=(int)mag){
				MoveToEx(hdc,0, y,NULL);
				LineTo(hdc,rct.right,y);
			}
			

			hGPen = CreatePen(PS_SOLID,1,RGB(0,255,0));
			hGOldPen = (HPEN)SelectObject(hdc,hGPen);
			
			
			if(!(function == "" && function.empty())){
				

				for(vals[0] = -rct.right; vals[0] <= rct.right; vals[0] += 0.1)
				{
					px = (int)(  mag * vals[0] ) + ox;
					py = (int)(- mag * fparser.Eval(vals) ) + oy;
					if(vals[0] == -rct.right)
						MoveToEx(hdc,px,py,NULL);
					else
						LineTo(hdc,px,py);
				}
			}
			DeleteObject(hPen);
			SelectObject(hdc,hOldPen);
			DeleteObject(hGPen);
			SelectObject(hdc,hGOldPen);
			
            EndPaint(hWnd, &ps);
            break;
		case WM_MOUSEMOVE:
			GetCursorPos(&point);
			ScreenToClient(hWnd,&point);
			GetClientRect(hWnd,&rct);
			sprintf(points,"(X = %.1lf,Y = %.1lf)",(point.x-rct.right/2)/mag,(-point.y+rct.bottom/2)/mag);
			SendMessageA(hStatus,SB_SETTEXTA,0|0,(LPARAM)points);
			break;

		case WM_DESTROY:
			PostQuitMessage(0);
			break;
		default:
			return (DefWindowProc(hWnd, msg, wp, lp));
	}
	return 0;
}

HWND ToolBarCreate(HWND hWnd)
{
	HWND hTool;

	InitCommonControls();

	hTool = CreateWindowEx(
			WS_EX_TOOLWINDOW, 
			TOOLBARCLASSNAME,
             	NULL,
             	WS_CHILD | WS_VISIBLE |
			CCS_ADJUSTABLE | CCS_NORESIZE,
			0,0,0,32,
             	hWnd,
             	NULL,
             	hInst,
             	NULL);


	SendMessage(hTool, TB_BUTTONSTRUCTSIZE, (WPARAM)sizeof(TBBUTTON), 0);

	return hTool;
}

HWND StatusbarCreate(HWND hWnd)
{
	HWND hStatus;
	InitCommonControls();
	hStatus = CreateWindowExA(0,
		STATUSCLASSNAMEA,
		NULL,
		WS_CHILD | SBARS_SIZEGRIP | CCS_BOTTOM | WS_VISIBLE,
		0,
		0,
		0,
		0,
		hWnd,
		(HMENU)IDM_STATUS,
		hInst,
		NULL);
	return hStatus;
}

BOOL CheckString(char *buff)
{
	unsigned char *check = (unsigned char *)buff;
	int len;
	for(len = 0; check[len];len++)
		;

	for(int i = 0; i < len;i++){
		if(!(ispunct(check[i])||islower(check[i])||isdigit(check[i])))
			return FALSE;
	}
	return TRUE;
}

