/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.betwixt.AttributeDescriptor;
import org.apache.commons.betwixt.ElementDescriptor;
import org.apache.commons.betwixt.NodeDescriptor;
import org.apache.commons.betwixt.XMLBeanInfo;
import org.apache.commons.betwixt.digester.XMLBeanInfoDigester;
import org.apache.commons.betwixt.digester.XMLIntrospectorHelper;
import org.apache.commons.betwixt.expression.EmptyExpression;
import org.apache.commons.betwixt.expression.IteratorExpression;
import org.apache.commons.betwixt.expression.StringExpression;
import org.apache.commons.betwixt.registry.DefaultXMLBeanInfoRegistry;
import org.apache.commons.betwixt.registry.XMLBeanInfoRegistry;
import org.apache.commons.betwixt.strategy.DefaultNameMapper;
import org.apache.commons.betwixt.strategy.DefaultPluralStemmer;
import org.apache.commons.betwixt.strategy.NameMapper;
import org.apache.commons.betwixt.strategy.PluralStemmer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XMLIntrospector {
    protected Log log = LogFactory.getLog((Class)(class$org$apache$commons$betwixt$XMLIntrospector == null ? (class$org$apache$commons$betwixt$XMLIntrospector = XMLIntrospector.class$("org.apache.commons.betwixt.XMLIntrospector")) : class$org$apache$commons$betwixt$XMLIntrospector));
    private boolean attributesForPrimitives = false;
    private boolean wrapCollectionsInElement = true;
    private XMLBeanInfoRegistry registry = new DefaultXMLBeanInfoRegistry();
    private XMLBeanInfoDigester digester;
    private PluralStemmer pluralStemmer;
    private NameMapper elementNameMapper;
    private NameMapper attributeNameMapper;
    private boolean useBeanInfoSearchPath = false;
    static /* synthetic */ Class class$org$apache$commons$betwixt$XMLIntrospector;
    static /* synthetic */ Class class$java$util$Map;

    public Log getLog() {
        return this.log;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public XMLBeanInfoRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(XMLBeanInfoRegistry registry) {
        this.registry = registry;
    }

    public boolean isCachingEnabled() {
        return true;
    }

    public void setCachingEnabled(boolean cachingEnabled) {
    }

    public void flushCache() {
    }

    public XMLBeanInfo introspect(Object bean) throws IntrospectionException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Introspecting...");
            this.log.debug(bean);
        }
        return this.introspect(bean.getClass());
    }

    public XMLBeanInfo introspect(Class aClass) throws IntrospectionException {
        XMLBeanInfo xmlInfo;
        String[] searchPath = null;
        if (!this.useBeanInfoSearchPath) {
            searchPath = Introspector.getBeanInfoSearchPath();
            Introspector.setBeanInfoSearchPath(new String[0]);
        }
        if ((xmlInfo = this.registry.get(aClass)) == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Attempting to lookup an XML descriptor for class: " + aClass));
            }
            if ((xmlInfo = this.findByXMLDescriptor(aClass)) == null) {
                BeanInfo info = Introspector.getBeanInfo(aClass);
                xmlInfo = this.introspect(info);
            }
            if (xmlInfo != null) {
                this.registry.put(aClass, xmlInfo);
            }
        } else {
            this.log.trace((Object)"Used cached XMLBeanInfo.");
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)xmlInfo);
        }
        if (!this.useBeanInfoSearchPath) {
            Introspector.setBeanInfoSearchPath(searchPath);
        }
        return xmlInfo;
    }

    public XMLBeanInfo introspect(BeanInfo beanInfo) throws IntrospectionException {
        XMLBeanInfo answer = this.createXMLBeanInfo(beanInfo);
        BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
        Class<?> beanClass = beanDescriptor.getBeanClass();
        ElementDescriptor elementDescriptor = new ElementDescriptor();
        elementDescriptor.setLocalName(this.getElementNameMapper().mapTypeToElementName(beanDescriptor.getName()));
        elementDescriptor.setPropertyType(beanInfo.getBeanDescriptor().getBeanClass());
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)elementDescriptor);
        }
        if (this.isPrimitiveType(beanClass)) {
            elementDescriptor.setTextExpression(StringExpression.getInstance());
            elementDescriptor.setPrimitiveType(true);
        } else if (this.isLoopType(beanClass)) {
            ElementDescriptor loopDescriptor = new ElementDescriptor();
            loopDescriptor.setContextExpression(new IteratorExpression(EmptyExpression.getInstance()));
            if ((class$java$util$Map == null ? (class$java$util$Map = XMLIntrospector.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(beanClass)) {
                loopDescriptor.setQualifiedName("entry");
            }
            elementDescriptor.setElementDescriptors(new ElementDescriptor[]{loopDescriptor});
        } else {
            int size;
            ArrayList elements = new ArrayList();
            ArrayList attributes = new ArrayList();
            this.addProperties(beanInfo, elements, attributes);
            BeanInfo[] additionals = beanInfo.getAdditionalBeanInfo();
            if (additionals != null) {
                int i = 0;
                int size2 = additionals.length;
                while (i < size2) {
                    BeanInfo otherInfo = additionals[i];
                    this.addProperties(otherInfo, elements, attributes);
                    ++i;
                }
            }
            if ((size = elements.size()) > 0) {
                ElementDescriptor[] descriptors = new ElementDescriptor[size];
                elements.toArray(descriptors);
                elementDescriptor.setElementDescriptors(descriptors);
            }
            if ((size = attributes.size()) > 0) {
                AttributeDescriptor[] descriptors = new AttributeDescriptor[size];
                attributes.toArray(descriptors);
                elementDescriptor.setAttributeDescriptors(descriptors);
            }
        }
        answer.setElementDescriptor(elementDescriptor);
        XMLIntrospectorHelper.defaultAddMethods(this, elementDescriptor, beanClass);
        return answer;
    }

    public boolean isAttributesForPrimitives() {
        return this.attributesForPrimitives;
    }

    public void setAttributesForPrimitives(boolean attributesForPrimitives) {
        this.attributesForPrimitives = attributesForPrimitives;
    }

    public boolean isWrapCollectionsInElement() {
        return this.wrapCollectionsInElement;
    }

    public void setWrapCollectionsInElement(boolean wrapCollectionsInElement) {
        this.wrapCollectionsInElement = wrapCollectionsInElement;
    }

    public PluralStemmer getPluralStemmer() {
        if (this.pluralStemmer == null) {
            this.pluralStemmer = this.createPluralStemmer();
        }
        return this.pluralStemmer;
    }

    public void setPluralStemmer(PluralStemmer pluralStemmer) {
        this.pluralStemmer = pluralStemmer;
    }

    public NameMapper getNameMapper() {
        return this.getElementNameMapper();
    }

    public void setNameMapper(NameMapper nameMapper) {
        this.setElementNameMapper(nameMapper);
    }

    public NameMapper getElementNameMapper() {
        if (this.elementNameMapper == null) {
            this.elementNameMapper = this.createNameMapper();
        }
        return this.elementNameMapper;
    }

    public void setElementNameMapper(NameMapper nameMapper) {
        this.elementNameMapper = nameMapper;
    }

    public NameMapper getAttributeNameMapper() {
        if (this.attributeNameMapper == null) {
            this.attributeNameMapper = this.createNameMapper();
        }
        return this.attributeNameMapper;
    }

    public void setAttributeNameMapper(NameMapper nameMapper) {
        this.attributeNameMapper = nameMapper;
    }

    protected PluralStemmer createPluralStemmer() {
        return new DefaultPluralStemmer();
    }

    protected NameMapper createNameMapper() {
        return new DefaultNameMapper();
    }

    protected synchronized XMLBeanInfo findByXMLDescriptor(Class aClass) {
        URL url;
        String name = aClass.getName();
        int idx = name.lastIndexOf(46);
        if (idx >= 0) {
            name = name.substring(idx + 1);
        }
        if ((url = aClass.getResource(name = name + ".betwixt")) != null) {
            try {
                String urlText = url.toString();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Parsing Betwixt XML descriptor: " + urlText));
                }
                if (this.digester == null) {
                    this.digester = new XMLBeanInfoDigester();
                    this.digester.setXMLIntrospector(this);
                }
                this.digester.setBeanClass(aClass);
                return (XMLBeanInfo)this.digester.parse(urlText);
            }
            catch (Exception e) {
                this.log.warn((Object)("Caught exception trying to parse: " + name), (Throwable)e);
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Could not find betwixt file " + name));
        }
        return null;
    }

    protected void addProperties(BeanInfo beanInfo, List elements, List attributes) throws IntrospectionException {
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors != null) {
            int i = 0;
            int size = descriptors.length;
            while (i < size) {
                this.addProperty(beanInfo, descriptors[i], elements, attributes);
                ++i;
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)elements);
            this.log.trace((Object)attributes);
        }
    }

    protected void addProperty(BeanInfo beanInfo, PropertyDescriptor propertyDescriptor, List elements, List attributes) throws IntrospectionException {
        NodeDescriptor nodeDescriptor = XMLIntrospectorHelper.createDescriptor(propertyDescriptor, this.isAttributesForPrimitives(), this);
        if (nodeDescriptor == null) {
            return;
        }
        if (nodeDescriptor instanceof ElementDescriptor) {
            elements.add(nodeDescriptor);
        } else {
            attributes.add(nodeDescriptor);
        }
    }

    protected XMLBeanInfo createXMLBeanInfo(BeanInfo beanInfo) {
        XMLBeanInfo answer = new XMLBeanInfo(beanInfo.getBeanDescriptor().getBeanClass());
        return answer;
    }

    public boolean isLoopType(Class type) {
        return XMLIntrospectorHelper.isLoopType(type);
    }

    public boolean isPrimitiveType(Class type) {
        return XMLIntrospectorHelper.isPrimitiveType(type);
    }

    public boolean useBeanInfoSearchPath() {
        return this.useBeanInfoSearchPath;
    }

    public void setUseBeanInfoSearchPath(boolean useBeanInfoSearchPath) {
        this.useBeanInfoSearchPath = useBeanInfoSearchPath;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

