/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.deploy.deployers;

import org.apache.maven.deploy.DeployRequest;
import org.apache.maven.deploy.RepositoryInfo;
import org.apache.maven.deploy.deployers.AbstractDeployer;
import org.apache.maven.deploy.exceptions.AuthenticationException;
import org.apache.maven.deploy.exceptions.TransferFailedException;

public class ExternalDeployer
extends AbstractDeployer {
    public static final String PROTOCOL = "external://";
    private String cmd = null;

    public void init(RepositoryInfo repoInfo) throws AuthenticationException {
        this.cmd = repoInfo.getHost();
    }

    public void release() {
    }

    public void deploy(DeployRequest request) throws TransferFailedException {
        String[] params = new String[]{request.getSrcFile(), request.getDestFile()};
        try {
            System.out.println("Staring external process: '" + this.cmd + "' to deploy:'" + request.getDestFile());
            Process process = Runtime.getRuntime().exec(this.cmd, params);
            process.waitFor();
            System.out.println("External process finished");
        }
        catch (Exception e) {
            throw new TransferFailedException("Failed to deploy with external program", e);
        }
    }
}

