/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.struts;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.j2ee.WarFile;
import org.apache.maven.struts.Action;
import org.apache.maven.struts.FormBean;
import org.apache.maven.struts.Forward;
import org.apache.maven.struts.StrutsEntityResolver;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.EntityResolver;

public class Struts10WarFile
extends WarFile {
    public static final String DEFAULT_CONFIG = "WEB-INF/struts-config.xml";
    private String config = "WEB-INF/struts-config.xml";
    public static final String DEFAULT_ACTIONSERVLET_NAME = "action";
    private String actionServletName = "action";

    public Struts10WarFile(String name) throws IOException {
        super(name);
    }

    public Struts10WarFile(String name, boolean verify) throws IOException {
        super(name, verify);
    }

    public Struts10WarFile(File warFile) throws IOException {
        super(warFile);
    }

    public Struts10WarFile(File warFile, boolean verify) throws IOException {
        super(warFile, verify);
    }

    public Struts10WarFile(File warFile, boolean verify, int mode) throws IOException {
        super(warFile, verify, mode);
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public JarEntry getStrutsConfigEntry() {
        return ((JarFile)((Object)this)).getJarEntry(this.getConfig());
    }

    private Document getStrutsConfig() throws IOException {
        if (this.getStrutsConfigEntry() == null) {
            throw new IOException("Attempted to get non-existent config");
        }
        try {
            SAXReader xmlReader = new SAXReader(false);
            xmlReader.setEntityResolver((EntityResolver)((Object)new StrutsEntityResolver()));
            InputStream configStream = ((JarFile)((Object)this)).getInputStream(this.getStrutsConfigEntry());
            Document configXml = xmlReader.read(configStream);
            return configXml;
        }
        catch (DocumentException de) {
            de.printStackTrace();
            throw new IOException(de.getMessage());
        }
    }

    public List getFormBeans() throws IOException {
        ArrayList<FormBean> formBeans = new ArrayList<FormBean>();
        Document config = this.getStrutsConfig();
        List formBeanNodes = config.selectNodes("/struts-config/form-beans/form-bean");
        Element formBeanNode = null;
        FormBean formBean = null;
        Iterator nodes = formBeanNodes.iterator();
        while (nodes.hasNext()) {
            formBeanNode = (Element)nodes.next();
            formBean = new FormBean();
            formBean.setClassName(formBeanNode.attributeValue("className"));
            formBean.setName(formBeanNode.attributeValue("name"));
            formBean.setType(formBeanNode.attributeValue("type"));
            formBeans.add(formBean);
        }
        return formBeans;
    }

    public List getActions() throws IOException {
        ArrayList<Action> actions = new ArrayList<Action>();
        Document config = this.getStrutsConfig();
        List actionNodes = config.selectNodes("/struts-config/action-mappings/action");
        Element actionNode = null;
        Action action = null;
        Iterator nodes = actionNodes.iterator();
        while (nodes.hasNext()) {
            actionNode = (Element)nodes.next();
            action = new Action();
            action.setClassName(actionNode.attributeValue("className"));
            action.setName(actionNode.attributeValue("name"));
            action.setPath(actionNode.attributeValue("path"));
            action.setScope(actionNode.attributeValue("scope"));
            action.setType(actionNode.attributeValue("type"));
            action.setUnknown(actionNode.attributeValue("unknown"));
            action.setValidate(actionNode.attributeValue("validate"));
            actions.add(action);
        }
        return actions;
    }

    public String getFormBeansType() throws IOException {
        String type = null;
        Element formBeans = (Element)this.getStrutsConfig().selectSingleNode("/struts-config/form-beans");
        if (formBeans != null) {
            type = formBeans.attributeValue("type");
        }
        return type;
    }

    public String getGlobalForwardsType() throws IOException {
        String type = null;
        Element forwards = (Element)this.getStrutsConfig().selectSingleNode("/struts-config/global-forwards");
        if (forwards != null) {
            type = forwards.attributeValue("type");
        }
        return type;
    }

    public List getForwards() throws IOException {
        ArrayList<Forward> forwards = new ArrayList<Forward>();
        Document config = this.getStrutsConfig();
        List nodes = config.selectNodes("/struts-config/global-forwards/forward");
        Element element = null;
        Forward forward = null;
        int index = 0;
        while (index < nodes.size()) {
            element = (Element)nodes.get(index);
            forward = new Forward();
            forward.setName(element.attributeValue("name"));
            forward.setPath(element.attributeValue("path"));
            if (element.attribute("className") != null) {
                forward.setClassName(element.attributeValue("className"));
            }
            if (element.attribute("redirect") != null) {
                forward.setRedirect(element.attributeValue("redirect"));
            }
            forwards.add(forward);
            ++index;
        }
        return forwards;
    }

    public String getActionServletPattern() throws IOException {
        return (String)this.getServletMappings().get(this.getActionServletName());
    }

    public String getActionServletName() {
        return this.actionServletName;
    }

    public void setActionServletName(String actionServletName) {
        if (actionServletName == null) {
            throw new NullPointerException("action servlet name can't be null");
        }
        this.actionServletName = actionServletName;
    }
}

