/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jnlp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;

public class UpdateManifest {
    private File inputJar;
    private File manifest;
    private File outputDir;

    public void process() throws Exception {
        System.out.println("Update Manifest in " + this.inputJar.getName());
        JarFile jarFile = new JarFile(this.inputJar);
        Enumeration<JarEntry> enumeration = jarFile.entries();
        File outputJar = new File(this.outputDir, this.inputJar.getName());
        FileOutputStream fos = new FileOutputStream(outputJar);
        JarOutputStream jos = new JarOutputStream(fos);
        while (enumeration.hasMoreElements()) {
            this.process(jarFile, jos, enumeration.nextElement());
        }
        jos.close();
        jarFile.close();
        outputJar.setLastModified(this.inputJar.lastModified());
    }

    private void process(JarFile jarFile, JarOutputStream jos, JarEntry entry) throws Exception {
        InputStream is = jarFile.getInputStream(entry);
        JarEntry je = entry;
        if (entry.getName().equalsIgnoreCase("META-INF/MANIFEST.MF")) {
            je = new JarEntry("META-INF/MANIFEST.MF");
            is = new FileInputStream(this.manifest);
        }
        JarEntry destEntry = new JarEntry(je.getName());
        jos.putNextEntry(destEntry);
        byte[] buffer = new byte[2048];
        int read = 0;
        while ((read = is.read(buffer)) > 0) {
            jos.write(buffer, 0, read);
        }
        jos.closeEntry();
    }

    public void setInputJar(File input) {
        this.inputJar = input;
    }

    public File getInputJar() {
        return this.inputJar;
    }

    public void setManifest(File manifest) {
        this.manifest = manifest;
    }

    public File getManifest() {
        return this.manifest;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public File getOutputDir() {
        return this.outputDir;
    }
}

