/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.dom;

import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.CDATA;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.Entity;
import org.dom4j.Namespace;
import org.dom4j.ProcessingInstruction;
import org.dom4j.QName;
import org.dom4j.Text;
import org.dom4j.dom.DOMAttribute;
import org.dom4j.dom.DOMCDATA;
import org.dom4j.dom.DOMComment;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMDocumentType;
import org.dom4j.dom.DOMElement;
import org.dom4j.dom.DOMEntityReference;
import org.dom4j.dom.DOMNamespace;
import org.dom4j.dom.DOMProcessingInstruction;
import org.dom4j.dom.DOMText;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;

public class DOMDocumentFactory
extends DocumentFactory
implements DOMImplementation {
    private static final ThreadLocal singlePerThread = new ThreadLocal();
    private static String domDocumentFactoryClassName = null;

    protected DOMDocumentType asDocumentType(org.w3c.dom.DocumentType documentType) {
        if (documentType instanceof DOMDocumentType) {
            return (DOMDocumentType)documentType;
        }
        return new DOMDocumentType(documentType.getName(), documentType.getPublicId(), documentType.getSystemId());
    }

    public Attribute createAttribute(Element owner, QName qname, String value) {
        return new DOMAttribute(qname, value);
    }

    public CDATA createCDATA(String text) {
        return new DOMCDATA(text);
    }

    public Comment createComment(String text) {
        return new DOMComment(text);
    }

    public DocumentType createDocType(String name, String publicId, String systemId) {
        return new DOMDocumentType(name, publicId, systemId);
    }

    public Document createDocument() {
        DOMDocument answer = new DOMDocument();
        answer.setDocumentFactory(this);
        return answer;
    }

    public org.w3c.dom.Document createDocument(String namespaceURI, String qualifiedName, org.w3c.dom.DocumentType documentType) throws DOMException {
        DOMDocumentType docType = this.asDocumentType(documentType);
        DOMDocument document = new DOMDocument(docType);
        document.addElement(this.createQName(qualifiedName, namespaceURI));
        return document;
    }

    public org.w3c.dom.DocumentType createDocumentType(String qualifiedName, String publicId, String systemId) throws DOMException {
        return new DOMDocumentType(qualifiedName, publicId, systemId);
    }

    public Element createElement(QName qname) {
        return new DOMElement(qname);
    }

    public Element createElement(QName qname, int attributeCount) {
        return new DOMElement(qname, attributeCount);
    }

    public Entity createEntity(String name) {
        return new DOMEntityReference(name);
    }

    public Entity createEntity(String name, String text) {
        return new DOMEntityReference(name, text);
    }

    public Namespace createNamespace(String prefix, String uri) {
        return new DOMNamespace(prefix, uri);
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) {
        return new DOMProcessingInstruction(target, data);
    }

    public ProcessingInstruction createProcessingInstruction(String target, Map data) {
        return new DOMProcessingInstruction(target, data);
    }

    public Text createText(String text) {
        return new DOMText(text);
    }

    public static DocumentFactory getInstance() {
        DOMDocumentFactory fact = (DOMDocumentFactory)singlePerThread.get();
        if (fact == null) {
            fact = new DOMDocumentFactory();
            singlePerThread.set(fact);
        }
        return fact;
    }

    public boolean hasFeature(String feature, String version) {
        return false;
    }
}

