/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.linkcheck;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.linkcheck.LinkCheckResult;
import org.apache.maven.linkcheck.validation.LinkValidationItem;
import org.apache.maven.linkcheck.validation.LinkValidationResult;
import org.apache.maven.linkcheck.validation.LinkValidatorManager;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.DOMReader;
import org.w3c.tidy.Tidy;

public class FileToCheck {
    private static Log LOG = LogFactory.getLog((Class)(class$org$apache$maven$linkcheck$FileToCheck == null ? (class$org$apache$maven$linkcheck$FileToCheck = FileToCheck.class$("org.apache.maven.linkcheck.FileToCheck")) : class$org$apache$maven$linkcheck$FileToCheck));
    private File base;
    private File fileToCheck;
    private String status = "OK";
    private String message = "";
    private int successful;
    private int unsuccessful;
    public static final String STATUS_UNKNOWN = null;
    public static final String STATUS_JTIDY_FAILURE = "Unable to tidy source";
    public static final String STATUS_OK = "OK";
    private List links = new ArrayList();
    static /* synthetic */ Class class$org$apache$maven$linkcheck$FileToCheck;

    public FileToCheck(File base, File fileToCheck) {
        this.base = base;
        this.fileToCheck = fileToCheck;
    }

    public void check(LinkValidatorManager lvm) throws Exception {
        this.successful = 0;
        this.unsuccessful = 0;
        this.status = STATUS_OK;
        this.message = "";
        try {
            String href;
            Tidy tidy = new Tidy();
            Document doc = null;
            try {
                FileInputStream in = new FileInputStream(this.fileToCheck);
                tidy.setMakeClean(true);
                tidy.setXmlTags(true);
                tidy.setXmlOut(true);
                tidy.setQuiet(true);
                tidy.setShowWarnings(false);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintWriter errOut = new PrintWriter(baos);
                tidy.setErrout(errOut);
                LOG.debug((Object)("Processing:" + this.fileToCheck));
                tidy.setXHTML(true);
                org.w3c.dom.Document domDocument = tidy.parseDOM((InputStream)in, null);
                DOMReader domReader = new DOMReader();
                doc = domReader.read(domDocument);
                LOG.debug((Object)baos.toString());
            }
            catch (Throwable e) {
                LOG.info((Object)("Caught " + e.toString() + " processing " + this.getName()));
                LOG.info((Object)("Exception Message: " + e.getLocalizedMessage()));
                LinkCheckResult lcr = new LinkCheckResult();
                lcr.setStatus("PARSE FAILURE");
                lcr.setTarget("N/A");
                this.links.add(lcr);
                return;
            }
            ArrayList xpathResults = new ArrayList();
            xpathResults.addAll(doc.selectNodes("//a/@href"));
            xpathResults.addAll(doc.selectNodes("//img/@src"));
            xpathResults.addAll(doc.selectNodes("//link/@href"));
            xpathResults.addAll(doc.selectNodes("//script/@src"));
            HashMap<String, String> uniqueLinks = new HashMap<String, String>();
            Iterator linkIter = xpathResults.iterator();
            while (linkIter.hasNext()) {
                Node node = (Node)linkIter.next();
                href = node.getText();
                uniqueLinks.put(href, href);
            }
            Iterator iter = uniqueLinks.keySet().iterator();
            while (iter.hasNext()) {
                href = (String)iter.next();
                LOG.debug((Object)("Link Found: " + href));
                LinkCheckResult lcr = new LinkCheckResult();
                LinkValidationItem lvi = new LinkValidationItem(this.fileToCheck, href);
                LinkValidationResult result = lvm.validateLink(lvi);
                lcr.setTarget(href);
                switch (result.getStatus()) {
                    case 2: {
                        ++this.successful;
                        lcr.setStatus(STATUS_OK);
                        this.links.add(lcr);
                        break;
                    }
                    case 3: {
                        ++this.unsuccessful;
                        lcr.setStatus("UNKNOWN REF");
                        this.links.add(lcr);
                        break;
                    }
                    case 1: {
                        ++this.unsuccessful;
                        lcr.setStatus("NOT FOUND");
                        this.links.add(lcr);
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println(this.message);
            throw e;
        }
    }

    public String getMessage() {
        return this.message;
    }

    public String getStatus() {
        return this.status;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public List getResults() {
        return this.links;
    }

    public int getSuccessful() {
        return this.successful;
    }

    public int getUnsuccessful() {
        return this.unsuccessful;
    }

    public String getName() {
        String baseName = this.base.getAbsolutePath();
        String fileName = this.fileToCheck.getAbsolutePath();
        if (fileName.startsWith(baseName)) {
            fileName = fileName.substring(baseName.length() + 1);
        }
        fileName = fileName.replace('\\', '/');
        return fileName;
    }

    public String toXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("  <file>\n");
        buf.append("    <name>" + this.getName() + "</name>\n");
        buf.append("    <successful>" + this.getSuccessful() + "</successful>\n");
        buf.append("    <unsuccessful>" + this.getUnsuccessful() + "</unsuccessful>\n");
        Iterator iter = this.getResults().iterator();
        while (iter.hasNext()) {
            LinkCheckResult result = (LinkCheckResult)iter.next();
            buf.append(result.toXML());
        }
        buf.append("  </file>\n");
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

