/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.linkcheck;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.jelly.MavenJellyContext;
import org.apache.maven.linkcheck.FileToCheck;
import org.apache.maven.linkcheck.validation.FileLinkValidator;
import org.apache.maven.linkcheck.validation.HTTPLinkValidator;
import org.apache.maven.linkcheck.validation.LinkValidatorManager;
import org.apache.maven.linkcheck.validation.MailtoLinkValidator;
import org.apache.maven.project.Project;

public class LinkCheck {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$maven$linkcheck$LinkCheck == null ? (class$org$apache$maven$linkcheck$LinkCheck = LinkCheck.class$("org.apache.maven.linkcheck.LinkCheck")) : class$org$apache$maven$linkcheck$LinkCheck));
    private File output;
    private String outputEncoding;
    private File baseDir;
    private String cache;
    private String exclude;
    private Project project;
    private List filesToCheck = null;
    LinkValidatorManager lvm = null;
    static /* synthetic */ Class class$org$apache$maven$linkcheck$LinkCheck;

    public void setBasedir(File base) {
        this.baseDir = base;
    }

    public File getBasedir() {
        return this.baseDir;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public void doExecute() throws Exception {
        if (this.output == null) {
            throw new NullPointerException("output must be set");
        }
        LinkValidatorManager validator = this.getLinkValidatorManager();
        this.filesToCheck = new ArrayList();
        validator.loadCache(this.cache);
        ArrayList files = new ArrayList();
        LOG.debug((Object)"Locating all files to be checked...");
        this.findFiles(files, this.baseDir);
        LOG.debug((Object)"Located all files to be checked.");
        Iterator fileIter = files.iterator();
        while (fileIter.hasNext()) {
            FileToCheck flc = (FileToCheck)fileIter.next();
            try {
                this.filesToCheck.add(flc);
                LOG.info((Object)("Validating " + flc.getName()));
                flc.check(validator);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.createDocument(files);
        validator.saveCache(this.cache);
    }

    public List getFiles() {
        return this.filesToCheck;
    }

    public void findFiles(List allFiles, File base) {
        FilenameFilter ff = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                File n = new File(dir, name);
                if (n.isDirectory()) {
                    return true;
                }
                return name.endsWith(".html");
            }
        };
        File[] f = base.listFiles(ff);
        if (f != null) {
            int i = 0;
            while (i < f.length) {
                File file = f[i];
                if (file.isDirectory()) {
                    this.findFiles(allFiles, file);
                } else {
                    allFiles.add(new FileToCheck(this.baseDir, file));
                }
                ++i;
            }
        }
    }

    private void createDocument(List files) throws Exception {
        File dir = this.output.getParentFile();
        if (dir != null) {
            dir.mkdirs();
        }
        PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.output), this.getOutputEncoding()));
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"").append(this.getOutputEncoding()).append("\" ?>\n");
        out.write(buffer.toString());
        out.write(this.toXML());
        out.close();
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public LinkValidatorManager getLinkValidatorManager() {
        if (this.lvm == null) {
            MavenJellyContext ctx;
            this.lvm = new LinkValidatorManager();
            this.lvm.setExclude(this.exclude);
            this.lvm.addLinkValidator(new FileLinkValidator());
            if (this.getProject() == null) {
                LOG.error((Object)"maven-linkcheck-plugin: No project set.");
                ctx = new MavenJellyContext();
            } else {
                ctx = ((Project)this.getProject()).getContext();
            }
            this.lvm.addLinkValidator(new HTTPLinkValidator(ctx.getProxyHost(), ctx.getProxyPort(), ctx.getProxyUserName(), ctx.getProxyPassword()));
            this.lvm.addLinkValidator(new MailtoLinkValidator());
            this.lvm.loadCache(this.cache);
        }
        return this.lvm;
    }

    public String getCache() {
        return this.cache;
    }

    public void setCache(String cache) {
        this.cache = cache;
    }

    public String getExclude() {
        return this.exclude;
    }

    public void setExclude(String exclude) {
        this.exclude = exclude;
    }

    public String toXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("<linkcheck>\n");
        Iterator iter = this.getFiles().iterator();
        while (iter.hasNext()) {
            FileToCheck ftc = (FileToCheck)iter.next();
            buf.append(ftc.toXML());
        }
        buf.append("</linkcheck>\n");
        return buf.toString();
    }

    public Object getProject() {
        return this.project;
    }

    public void setProject(Object project) {
        this.project = (Project)project;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

