/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.linkcheck.validation;

import java.io.File;
import org.apache.maven.linkcheck.validation.LinkValidationItem;
import org.apache.maven.linkcheck.validation.LinkValidationResult;
import org.apache.maven.linkcheck.validation.LinkValidator;

public class FileLinkValidator
implements LinkValidator {
    private static final LinkValidationResult LVR_INVALID = new LinkValidationResult(1, false);
    private static final LinkValidationResult LVR_VALID = new LinkValidationResult(2, false);

    public LinkValidationResult validateLink(LinkValidationItem lvi) {
        File f = this.getFile(lvi);
        if (f.exists()) {
            return LVR_VALID;
        }
        return LVR_INVALID;
    }

    protected File getFile(LinkValidationItem lvi) {
        String link = lvi.getLink();
        if (link.indexOf(35) != -1 && (link = link.substring(0, link.indexOf(35))).trim().length() == 0) {
            return lvi.getSource();
        }
        File f = new File(lvi.getSource().getParentFile(), link);
        return f;
    }

    public Object getResourceKey(LinkValidationItem lvi) {
        String link = lvi.getLink();
        if (link.indexOf(58) != -1) {
            return null;
        }
        return this.getFile(lvi).getAbsolutePath();
    }
}

